/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.entity;

import java.io.Serializable;
import net.droidsolutions.droidcharts.awt.PathIterator;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.awt.Shape;

public class ChartEntity
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4445994133561919083L;
    private transient Shape area;
    private String toolTipText;
    private String urlText;

    public ChartEntity(Shape area) {
        this(area, null);
    }

    public ChartEntity(Shape area, String toolTipText) {
        this(area, toolTipText, null);
    }

    public ChartEntity(Shape area, String toolTipText, String urlText) {
        if (area == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        this.area = area;
        this.toolTipText = toolTipText;
        this.urlText = urlText;
    }

    public Shape getArea() {
        return this.area;
    }

    public void setArea(Shape area) {
        if (area == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        this.area = area;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String text) {
        this.toolTipText = text;
    }

    public String getURLText() {
        return this.urlText;
    }

    public void setURLText(String text) {
        this.urlText = text;
    }

    public String getShapeType() {
        if (this.area instanceof Rectangle2D) {
            return "rect";
        }
        return "poly";
    }

    public String getShapeCoords() {
        if (this.area instanceof Rectangle2D) {
            return this.getRectCoords((Rectangle2D)this.area);
        }
        return this.getPolyCoords(this.area);
    }

    private String getRectCoords(Rectangle2D rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException("Null 'rectangle' argument.");
        }
        int x1 = (int)rectangle.getX();
        int y1 = (int)rectangle.getY();
        int x2 = x1 + (int)rectangle.getWidth();
        int y2 = y1 + (int)rectangle.getHeight();
        if (x2 == x1) {
            ++x2;
        }
        if (y2 == y1) {
            ++y2;
        }
        return String.valueOf(x1) + "," + y1 + "," + x2 + "," + y2;
    }

    private String getPolyCoords(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        StringBuffer result = new StringBuffer();
        boolean first = true;
        float[] coords = new float[6];
        PathIterator pi = shape.getPathIterator(null, 1.0);
        while (!pi.isDone()) {
            pi.currentSegment(coords);
            if (first) {
                first = false;
                result.append((int)coords[0]);
                result.append(",").append((int)coords[1]);
            } else {
                result.append(",");
                result.append((int)coords[0]);
                result.append(",");
                result.append((int)coords[1]);
            }
            pi.next();
        }
        return result.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ChartEntity: ");
        buf.append("tooltip = ");
        buf.append(this.toolTipText);
        return buf.toString();
    }
}

