/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core;

import android.graphics.Paint;
import java.io.Serializable;
import java.text.AttributedString;
import java.text.CharacterIterator;
import net.droidsolutions.droidcharts.awt.Font;
import net.droidsolutions.droidcharts.awt.Line2D;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.awt.Shape;
import net.droidsolutions.droidcharts.core.data.general.Dataset;

public class LegendItem
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -797214582948827144L;
    private Dataset dataset;
    private Comparable seriesKey;
    private int datasetIndex;
    private int series;
    private String label;
    private Font labelFont;
    private transient Paint labelPaint;
    private transient AttributedString attributedLabel;
    private String description;
    private String toolTipText;
    private String urlText;
    private boolean shapeVisible;
    private transient Shape shape;
    private boolean shapeFilled;
    private transient Paint fillPaint;
    private boolean shapeOutlineVisible;
    private transient Paint outlinePaint;
    private transient float outlineStroke;
    private boolean lineVisible;
    private transient Shape line;
    private transient float lineStroke;
    private transient Paint linePaint;
    private static final Shape UNUSED_SHAPE = new Line2D.Float();
    private static final float UNUSED_STROKE = 0.0f;

    public LegendItem(String label) {
        this(label, -16777216);
    }

    public LegendItem(String label, int color2) {
        this(label, null, null, null, (Shape)new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0), color2);
    }

    public LegendItem(String label, String description, String toolTipText, String urlText, Shape shape, int fillColor) {
        this(label, description, toolTipText, urlText, true, shape, true, fillColor, false, -16777216, 0.0f, false, UNUSED_SHAPE, 0.0f, -16777216);
    }

    public LegendItem(String label, String description, String toolTipText, String urlText, Shape shape, int fillPaint, float outlineStroke, int outlinePaint) {
        this(label, description, toolTipText, urlText, true, shape, true, fillPaint, true, outlinePaint, outlineStroke, false, UNUSED_SHAPE, 0.0f, -16777216);
    }

    public LegendItem(String label, String description, String toolTipText, String urlText, Shape line, float lineStroke, int linePaint) {
        this(label, description, toolTipText, urlText, false, UNUSED_SHAPE, false, -16777216, false, -16777216, 0.0f, true, line, lineStroke, linePaint);
    }

    public LegendItem(String label, String description, String toolTipText, String urlText, boolean shapeVisible, Shape shape, boolean shapeFilled, int fillPaint, boolean shapeOutlineVisible, int outlinePaint, float outlineStroke, boolean lineVisible, Shape line, float lineStroke, int linePaint) {
        if (label == null) {
            throw new IllegalArgumentException("Null 'label' argument.");
        }
        this.label = label;
        this.labelPaint = null;
        this.attributedLabel = null;
        this.description = description;
        this.shapeVisible = shapeVisible;
        this.shape = shape;
        this.shapeFilled = shapeFilled;
        Paint p = new Paint(1);
        p.setColor(fillPaint);
        this.fillPaint = p;
        this.shapeOutlineVisible = shapeOutlineVisible;
        p = new Paint(1);
        p.setColor(outlinePaint);
        this.outlinePaint = p;
        this.outlineStroke = outlineStroke;
        this.lineVisible = lineVisible;
        this.line = line;
        this.lineStroke = lineStroke;
        p = new Paint(1);
        p.setColor(linePaint);
        this.linePaint = p;
        this.toolTipText = toolTipText;
        this.urlText = urlText;
    }

    public LegendItem(AttributedString label, String description, String toolTipText, String urlText, Shape shape, int fillPaint) {
        this(label, description, toolTipText, urlText, true, shape, true, fillPaint, false, -16777216, 0.0f, false, UNUSED_SHAPE, 0.0f, -16777216);
    }

    public LegendItem(AttributedString label, String description, String toolTipText, String urlText, Shape shape, int fillPaint, float outlineStroke, int outlinePaint) {
        this(label, description, toolTipText, urlText, true, shape, true, fillPaint, true, outlinePaint, outlineStroke, false, UNUSED_SHAPE, 0.0f, -16777216);
    }

    public LegendItem(AttributedString label, String description, String toolTipText, String urlText, Shape line, float lineStroke, int linePaint) {
        this(label, description, toolTipText, urlText, false, UNUSED_SHAPE, false, -16777216, false, -16777216, 0.0f, true, line, lineStroke, linePaint);
    }

    public LegendItem(AttributedString label, String description, String toolTipText, String urlText, boolean shapeVisible, Shape shape, boolean shapeFilled, int fillPaint, boolean shapeOutlineVisible, int outlinePaint, float outlineStroke, boolean lineVisible, Shape line, float lineStroke, int linePaint) {
        if (label == null) {
            throw new IllegalArgumentException("Null 'label' argument.");
        }
        if (line == null) {
            throw new IllegalArgumentException("Null 'line' argument.");
        }
        this.label = this.characterIteratorToString(label.getIterator());
        this.attributedLabel = label;
        this.description = description;
        this.shapeVisible = shapeVisible;
        this.shape = shape;
        this.shapeFilled = shapeFilled;
        Paint p = new Paint(1);
        p.setColor(fillPaint);
        this.fillPaint = p;
        this.shapeOutlineVisible = shapeOutlineVisible;
        p = new Paint(1);
        p.setColor(outlinePaint);
        this.outlinePaint = p;
        this.outlineStroke = outlineStroke;
        this.lineVisible = lineVisible;
        this.line = line;
        this.lineStroke = lineStroke;
        p = new Paint(1);
        p.setColor(linePaint);
        this.linePaint = p;
        this.toolTipText = toolTipText;
        this.urlText = urlText;
    }

    private String characterIteratorToString(CharacterIterator iterator) {
        int beginIndex;
        int endIndex = iterator.getEndIndex();
        int count = endIndex - (beginIndex = iterator.getBeginIndex());
        if (count <= 0) {
            return "";
        }
        char[] chars = new char[count];
        int i = 0;
        char c = iterator.first();
        while (c != '\uffff') {
            chars[i] = c;
            ++i;
            c = iterator.next();
        }
        return new String(chars);
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public int getDatasetIndex() {
        return this.datasetIndex;
    }

    public void setDatasetIndex(int index) {
        this.datasetIndex = index;
    }

    public Comparable getSeriesKey() {
        return this.seriesKey;
    }

    public void setSeriesKey(Comparable key) {
        this.seriesKey = key;
    }

    public int getSeriesIndex() {
        return this.series;
    }

    public void setSeriesIndex(int index) {
        this.series = index;
    }

    public String getLabel() {
        return this.label;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        this.labelPaint = paint;
    }

    public AttributedString getAttributedLabel() {
        return this.attributedLabel;
    }

    public String getDescription() {
        return this.description;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public String getURLText() {
        return this.urlText;
    }

    public boolean isShapeVisible() {
        return this.shapeVisible;
    }

    public Shape getShape() {
        return this.shape;
    }

    public boolean isShapeFilled() {
        return this.shapeFilled;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.fillPaint = paint;
    }

    public boolean isShapeOutlineVisible() {
        return this.shapeOutlineVisible;
    }

    public float getLineStroke() {
        return this.lineStroke;
    }

    public Paint getLinePaint() {
        return this.linePaint;
    }

    public void setLinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.linePaint = paint;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.outlinePaint = paint;
    }

    public float getOutlineStroke() {
        return this.outlineStroke;
    }

    public boolean isLineVisible() {
        return this.lineVisible;
    }

    public Shape getLine() {
        return this.line;
    }
}

