/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.view.View;
import java.text.DecimalFormat;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.common.TextAnchor;
import net.droidsolutions.droidcharts.core.ChartFactory;
import net.droidsolutions.droidcharts.core.JFreeChart;
import net.droidsolutions.droidcharts.core.axis.CategoryAxis;
import net.droidsolutions.droidcharts.core.axis.CategoryLabelPositions;
import net.droidsolutions.droidcharts.core.axis.NumberAxis;
import net.droidsolutions.droidcharts.core.axis.ValueAxis;
import net.droidsolutions.droidcharts.core.data.CategoryDataset;
import net.droidsolutions.droidcharts.core.data.general.DatasetUtilities;
import net.droidsolutions.droidcharts.core.label.ItemLabelAnchor;
import net.droidsolutions.droidcharts.core.label.ItemLabelPosition;
import net.droidsolutions.droidcharts.core.label.StandardCategoryItemLabelGenerator;
import net.droidsolutions.droidcharts.core.plot.CategoryPlot;
import net.droidsolutions.droidcharts.core.plot.PlotOrientation;
import net.droidsolutions.droidcharts.core.renderer.BarRenderer;

public class BarChartExampleView
extends View {
    private Rect mRect = new Rect();
    private Handler mHandler = new Handler();

    public BarChartExampleView(Context context) {
        super(context);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.getClipBounds(this.mRect);
        CategoryDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        chart.draw(canvas, new Rectangle2D.Double(0.0, 0.0, this.mRect.width(), this.mRect.height()));
        Paint p = new Paint();
        p.setColor(-65536);
    }

    public void repaint() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                BarChartExampleView.this.invalidate();
            }
        });
    }

    private CategoryDataset createDataset() {
        double[][] data = new double[][]{{40.0, 30.0, -20.5, 30.0, 6.0}};
        return DatasetUtilities.createCategoryDataset("Series ", "Category ", data);
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createBarChart("", "Category", "Value", dataset, PlotOrientation.VERTICAL, false, true, false);
        Paint white = new Paint(1);
        white.setColor(-1);
        Paint dkGray = new Paint(1);
        dkGray.setColor(-12303292);
        Paint lightGray = new Paint(1);
        lightGray.setColor(-3355444);
        lightGray.setStrokeWidth(10.0f);
        Paint black = new Paint(1);
        black.setColor(-16777216);
        Paint borderPaint = new Paint(1);
        borderPaint.setColor(-1);
        borderPaint.setStrokeWidth(5.0f);
        chart.setBorderPaint(borderPaint);
        chart.setBackgroundPaint(dkGray);
        CategoryPlot plot = chart.getCategoryPlot();
        Resources res = this.getResources();
        CustomRenderer renderer = new CustomRenderer(new int[]{res.getColor(2130968576), res.getColor(2130968577), res.getColor(2130968578), res.getColor(2130968579), res.getColor(2130968580), res.getColor(2130968581), res.getColor(2130968582), res.getColor(2130968583)});
        ItemLabelPosition p = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 45.0);
        renderer.setBasePositiveItemLabelPosition(p);
        plot.setRenderer(renderer);
        plot.setBackgroundPaint(dkGray);
        plot.setDomainGridlinePaint(lightGray);
        plot.setRangeGridlinePaint(lightGray);
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setLowerMargin(0.15);
        rangeAxis.setUpperMargin(0.15);
        rangeAxis.setLabelAngle(90.0);
        CategoryAxis domainAxis = plot.getDomainAxis();
        BarRenderer barRenderer = (BarRenderer)plot.getRenderer();
        DecimalFormat decimalformat1 = new DecimalFormat("$##,###.00");
        barRenderer.setBaseItemLabelGenerator(new StandardCategoryItemLabelGenerator("{2}", decimalformat1));
        barRenderer.setBaseItemLabelsVisible(true);
        barRenderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE11, TextAnchor.CENTER));
        barRenderer.setBaseNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE7, TextAnchor.CENTER));
        barRenderer.setItemLabelsVisible(true);
        chart.getCategoryPlot().setRenderer(renderer);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.STANDARD);
        return chart;
    }

    class CustomRenderer
    extends BarRenderer {
        private static final long serialVersionUID = 1L;
        private Paint[] paints;

        public CustomRenderer(int[] colors) {
            this.paints = new Paint[colors.length];
            int i = 0;
            int[] nArray = colors;
            int n = colors.length;
            int n2 = 0;
            while (n2 < n) {
                int col = nArray[n2];
                Paint paint = new Paint(1);
                paint.setAlpha(200);
                paint.setColor(col);
                paint.setStyle(Paint.Style.FILL_AND_STROKE);
                this.paints[i] = paint;
                ++i;
                ++n2;
            }
        }

        @Override
        public Paint getItemPaint(int row, int column) {
            return this.paints[column % this.paints.length];
        }
    }
}

