/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.model;

import java.util.ArrayList;
import java.util.List;
import org.achartengine.model.XYSeries;

public class XYValueSeries
extends XYSeries {
    private List<Double> mValue = new ArrayList<Double>();
    private double mMinValue = Double.MAX_VALUE;
    private double mMaxValue = -1.7976931348623157E308;

    public XYValueSeries(String string) {
        super(string);
    }

    public void add(double d, double d2, double d3) {
        super.add(d, d2);
        this.mValue.add(d3);
        this.updateRange(d3);
    }

    private void initRange() {
        this.mMinValue = Double.MAX_VALUE;
        this.mMaxValue = Double.MAX_VALUE;
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            this.updateRange(this.getValue(i));
        }
    }

    private void updateRange(double d) {
        this.mMinValue = Math.min(this.mMinValue, d);
        this.mMaxValue = Math.max(this.mMaxValue, d);
    }

    @Override
    public void add(double d, double d2) {
        this.add(d, d2, 0.0);
    }

    @Override
    public void remove(int n) {
        super.remove(n);
        double d = this.mValue.remove(n);
        if (d == this.mMinValue || d == this.mMaxValue) {
            this.initRange();
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.mValue.clear();
        this.initRange();
    }

    public double getValue(int n) {
        return this.mValue.get(n);
    }

    public double getMinValue() {
        return this.mMinValue;
    }

    public double getMaxValue() {
        return this.mMaxValue;
    }
}

