/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.title;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import net.droidsolutions.droidcharts.awt.Ellipse2D;
import net.droidsolutions.droidcharts.awt.Line2D;
import net.droidsolutions.droidcharts.awt.Path2D;
import net.droidsolutions.droidcharts.awt.PathIterator;
import net.droidsolutions.droidcharts.awt.Point2D;
import net.droidsolutions.droidcharts.awt.Polygon;
import net.droidsolutions.droidcharts.awt.Rectangle;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.awt.RectangularShape;
import net.droidsolutions.droidcharts.awt.Shape;
import net.droidsolutions.droidcharts.common.GradientPaintTransformer;
import net.droidsolutions.droidcharts.common.RectangleAnchor;
import net.droidsolutions.droidcharts.common.ShapeUtilities;
import net.droidsolutions.droidcharts.common.Size2D;
import net.droidsolutions.droidcharts.common.StandardGradientPaintTransformer;
import net.droidsolutions.droidcharts.core.block.AbstractBlock;
import net.droidsolutions.droidcharts.core.block.Block;
import net.droidsolutions.droidcharts.core.block.LengthConstraintType;
import net.droidsolutions.droidcharts.core.block.RectangleConstraint;

public class LegendGraphic
extends AbstractBlock
implements Block {
    static final long serialVersionUID = -1338791523854985009L;
    private boolean shapeVisible;
    private transient Shape shape;
    private RectangleAnchor shapeLocation;
    private RectangleAnchor shapeAnchor;
    private boolean shapeFilled;
    private transient Paint fillPaint;
    private GradientPaintTransformer fillPaintTransformer;
    private boolean shapeOutlineVisible;
    private transient Paint outlinePaint;
    private transient float outlineStroke;
    private boolean lineVisible;
    private transient Shape line;
    private transient float lineStroke;
    private transient Paint linePaint;

    public LegendGraphic(Shape shape, Paint fillPaint) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        if (fillPaint == null) {
            throw new IllegalArgumentException("Null 'fillPaint' argument.");
        }
        this.shapeVisible = true;
        this.shape = shape;
        this.shapeAnchor = RectangleAnchor.CENTER;
        this.shapeLocation = RectangleAnchor.CENTER;
        this.shapeFilled = true;
        this.fillPaint = fillPaint;
        this.fillPaintTransformer = new StandardGradientPaintTransformer();
        this.setPadding(2.0, 2.0, 2.0, 2.0);
    }

    public boolean isShapeVisible() {
        return this.shapeVisible;
    }

    public void setShapeVisible(boolean visible) {
        this.shapeVisible = visible;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public boolean isShapeFilled() {
        return this.shapeFilled;
    }

    public void setShapeFilled(boolean filled) {
        this.shapeFilled = filled;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint paint) {
        this.fillPaint = paint;
    }

    public GradientPaintTransformer getFillPaintTransformer() {
        return this.fillPaintTransformer;
    }

    public void setFillPaintTransformer(GradientPaintTransformer transformer) {
        if (transformer == null) {
            throw new IllegalArgumentException("Null 'transformer' argument.");
        }
        this.fillPaintTransformer = transformer;
    }

    public boolean isShapeOutlineVisible() {
        return this.shapeOutlineVisible;
    }

    public void setShapeOutlineVisible(boolean visible) {
        this.shapeOutlineVisible = visible;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        this.outlinePaint = paint;
    }

    public float getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(float stroke) {
        this.outlineStroke = stroke;
    }

    public RectangleAnchor getShapeAnchor() {
        return this.shapeAnchor;
    }

    public void setShapeAnchor(RectangleAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.shapeAnchor = anchor;
    }

    public RectangleAnchor getShapeLocation() {
        return this.shapeLocation;
    }

    public void setShapeLocation(RectangleAnchor location) {
        if (location == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        this.shapeLocation = location;
    }

    public boolean isLineVisible() {
        return this.lineVisible;
    }

    public void setLineVisible(boolean visible) {
        this.lineVisible = visible;
    }

    public Shape getLine() {
        return this.line;
    }

    public void setLine(Shape line) {
        this.line = line;
    }

    public Paint getLinePaint() {
        return this.linePaint;
    }

    public void setLinePaint(Paint paint) {
        this.linePaint = paint;
    }

    public float getLineStroke() {
        return this.lineStroke;
    }

    public void setLineStroke(float stroke) {
        this.lineStroke = stroke;
    }

    @Override
    public Size2D arrange(Canvas g2, RectangleConstraint constraint) {
        RectangleConstraint contentConstraint = this.toContentConstraint(constraint);
        LengthConstraintType w = contentConstraint.getWidthConstraintType();
        LengthConstraintType h = contentConstraint.getHeightConstraintType();
        Size2D contentSize = null;
        if (w == LengthConstraintType.NONE) {
            if (h == LengthConstraintType.NONE) {
                contentSize = this.arrangeNN(g2);
            } else {
                if (h == LengthConstraintType.RANGE) {
                    throw new RuntimeException("Not yet implemented.");
                }
                if (h == LengthConstraintType.FIXED) {
                    throw new RuntimeException("Not yet implemented.");
                }
            }
        } else if (w == LengthConstraintType.RANGE) {
            if (h == LengthConstraintType.NONE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (h == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (h == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not yet implemented.");
            }
        } else if (w == LengthConstraintType.FIXED) {
            if (h == LengthConstraintType.NONE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (h == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (h == LengthConstraintType.FIXED) {
                contentSize = new Size2D(contentConstraint.getWidth(), contentConstraint.getHeight());
            }
        }
        return new Size2D(this.calculateTotalWidth(contentSize.getWidth()), this.calculateTotalHeight(contentSize.getHeight()));
    }

    protected Size2D arrangeNN(Canvas g2) {
        Rectangle2D contentSize = new Rectangle2D.Double();
        if (this.line != null) {
            ((Rectangle2D)contentSize).setRect(this.line.getBounds2D());
        }
        if (this.shape != null) {
            contentSize = ((Rectangle2D)contentSize).createUnion(this.shape.getBounds2D());
        }
        return new Size2D(((RectangularShape)contentSize).getWidth(), ((RectangularShape)contentSize).getHeight());
    }

    public void draw(Canvas g2, Rectangle2D area) {
        Point2D location;
        area = this.trimMargin(area);
        this.drawBorder(g2, area);
        area = this.trimBorder(area);
        area = this.trimPadding(area);
        if (this.lineVisible) {
            location = RectangleAnchor.coordinates(area, this.shapeLocation);
            Shape aLine = ShapeUtilities.createTranslatedShape(this.getLine(), this.shapeAnchor, location.getX(), location.getY());
            this.linePaint.setStrokeWidth(this.lineStroke);
            if (aLine instanceof Line2D) {
                Line2D line = (Line2D)aLine;
                g2.drawLine((float)line.getX1(), (float)line.getY1(), (float)line.getX2(), (float)line.getY2(), this.linePaint);
            }
        }
        if (this.shapeVisible) {
            location = RectangleAnchor.coordinates(area, this.shapeLocation);
            Shape s = ShapeUtilities.createTranslatedShape(this.shape, this.shapeAnchor, location.getX(), location.getY());
            if (this.shape instanceof Rectangle2D) {
                Paint p;
                Rectangle2D rect = (Rectangle2D)this.shape;
                if (this.shapeFilled) {
                    p = this.fillPaint;
                    p.setStyle(Paint.Style.FILL);
                    g2.drawRect((float)location.getX(), (float)location.getY(), (float)(location.getX() + rect.getWidth()), (float)(location.getY() + rect.getHeight()), p);
                }
                if (this.shapeOutlineVisible) {
                    p = this.outlinePaint;
                    p.setStyle(Paint.Style.STROKE);
                    p.setStrokeWidth(this.outlineStroke);
                    g2.drawRect((float)location.getX(), (float)location.getY(), (float)(location.getX() + rect.getWidth()), (float)(location.getY() + rect.getHeight()), p);
                }
            } else if (this.shape instanceof Ellipse2D) {
                Paint p;
                Ellipse2D ellips = (Ellipse2D)this.shape;
                if (this.shapeFilled) {
                    p = this.fillPaint;
                    p.setStyle(Paint.Style.FILL);
                    g2.drawCircle((float)location.getX(), (float)location.getY(), 5.0f, this.fillPaint);
                }
                if (this.shapeOutlineVisible) {
                    p = this.outlinePaint;
                    p.setStyle(Paint.Style.STROKE);
                    p.setStrokeWidth(this.outlineStroke);
                    g2.drawCircle((float)location.getX(), (float)location.getY(), 5.0f, this.fillPaint);
                }
            } else if (this.shape instanceof Polygon) {
                Path path;
                Paint p;
                Path2D polygon = (Path2D)s;
                if (this.shapeFilled) {
                    p = this.fillPaint;
                    p.setStyle(Paint.Style.FILL_AND_STROKE);
                    path = this.convertAwtPathToAndroid(polygon.getPathIterator(null));
                    g2.drawPath(path, p);
                }
                if (this.shapeOutlineVisible) {
                    p = this.outlinePaint;
                    p.setStyle(Paint.Style.STROKE);
                    p.setStrokeWidth(this.outlineStroke);
                    path = this.convertAwtPathToAndroid(polygon.getPathIterator(null));
                    g2.drawPath(path, p);
                }
            }
        }
    }

    @Override
    public Object draw(Canvas g2, Rectangle2D area, Object params) {
        this.draw(g2, area);
        return null;
    }

    @Override
    public void draw(Canvas g2, Rectangle area) {
        this.draw(g2, area);
    }

    private Path convertAwtPathToAndroid(PathIterator pi) {
        Path path = new Path();
        float[] coords = new float[6];
        while (!pi.isDone()) {
            int windingRule = pi.getWindingRule();
            if (windingRule == 0) {
                path.setFillType(Path.FillType.EVEN_ODD);
            } else {
                path.setFillType(Path.FillType.INVERSE_EVEN_ODD);
            }
            int pathType = pi.currentSegment(coords);
            switch (pathType) {
                case 4: {
                    path.close();
                    break;
                }
                case 3: {
                    path.cubicTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 1: {
                    path.lineTo(coords[0], coords[1]);
                    break;
                }
                case 0: {
                    path.moveTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    path.quadTo(coords[0], coords[1], coords[2], coords[3]);
                }
            }
            pi.next();
        }
        return path;
    }
}

