/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.renderer.xy;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import java.io.Serializable;
import net.droidsolutions.droidcharts.awt.Font;
import net.droidsolutions.droidcharts.awt.GeneralPath;
import net.droidsolutions.droidcharts.awt.Line2D;
import net.droidsolutions.droidcharts.awt.PathIterator;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.awt.Shape;
import net.droidsolutions.droidcharts.common.BooleanList;
import net.droidsolutions.droidcharts.common.BooleanUtilities;
import net.droidsolutions.droidcharts.common.RectangleEdge;
import net.droidsolutions.droidcharts.common.ShapeUtilities;
import net.droidsolutions.droidcharts.core.LegendItem;
import net.droidsolutions.droidcharts.core.axis.ValueAxis;
import net.droidsolutions.droidcharts.core.data.XYDataset;
import net.droidsolutions.droidcharts.core.entity.EntityCollection;
import net.droidsolutions.droidcharts.core.event.RendererChangeListener;
import net.droidsolutions.droidcharts.core.label.ItemLabelPosition;
import net.droidsolutions.droidcharts.core.label.XYItemLabelGenerator;
import net.droidsolutions.droidcharts.core.plot.CrosshairState;
import net.droidsolutions.droidcharts.core.plot.PlotOrientation;
import net.droidsolutions.droidcharts.core.plot.PlotRenderingInfo;
import net.droidsolutions.droidcharts.core.plot.XYPlot;
import net.droidsolutions.droidcharts.core.renderer.xy.AbstractXYItemRenderer;
import net.droidsolutions.droidcharts.core.renderer.xy.XYItemRenderer;
import net.droidsolutions.droidcharts.core.renderer.xy.XYItemRendererState;

public class XYLineAndShapeRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7435246895986425885L;
    private Boolean linesVisible = null;
    private BooleanList seriesLinesVisible = new BooleanList();
    private boolean baseLinesVisible;
    private transient Shape legendLine;
    private Boolean shapesVisible;
    private BooleanList seriesShapesVisible;
    private boolean baseShapesVisible;
    private Boolean shapesFilled;
    private BooleanList seriesShapesFilled;
    private boolean baseShapesFilled;
    private boolean drawOutlines;
    private boolean useFillPaint;
    private boolean useOutlinePaint;
    private boolean drawSeriesLineAsPath;

    public XYLineAndShapeRenderer() {
        this(true, true);
    }

    public XYLineAndShapeRenderer(boolean lines, boolean shapes) {
        this.baseLinesVisible = lines;
        this.legendLine = new Line2D.Double(-7.0, 0.0, 7.0, 0.0);
        this.shapesVisible = null;
        this.seriesShapesVisible = new BooleanList();
        this.baseShapesVisible = shapes;
        this.shapesFilled = null;
        this.useFillPaint = false;
        this.seriesShapesFilled = new BooleanList();
        this.baseShapesFilled = true;
        this.drawOutlines = true;
        this.useOutlinePaint = false;
        this.drawSeriesLineAsPath = false;
    }

    public boolean getDrawSeriesLineAsPath() {
        return this.drawSeriesLineAsPath;
    }

    public void setDrawSeriesLineAsPath(boolean flag) {
        if (this.drawSeriesLineAsPath != flag) {
            this.drawSeriesLineAsPath = flag;
        }
    }

    @Override
    public int getPassCount() {
        return 2;
    }

    public boolean getItemLineVisible(int series, int item) {
        Boolean flag = this.linesVisible;
        if (flag == null) {
            flag = this.getSeriesLinesVisible(series);
        }
        if (flag != null) {
            return flag;
        }
        return this.baseLinesVisible;
    }

    public Boolean getLinesVisible() {
        return this.linesVisible;
    }

    public void setLinesVisible(Boolean visible) {
        this.linesVisible = visible;
    }

    public void setLinesVisible(boolean visible) {
        this.setLinesVisible(BooleanUtilities.valueOf(visible));
    }

    public Boolean getSeriesLinesVisible(int series) {
        return this.seriesLinesVisible.getBoolean(series);
    }

    public void setSeriesLinesVisible(int series, Boolean flag) {
        this.seriesLinesVisible.setBoolean(series, flag);
    }

    public void setSeriesLinesVisible(int series, boolean visible) {
        this.setSeriesLinesVisible(series, BooleanUtilities.valueOf(visible));
    }

    public boolean getBaseLinesVisible() {
        return this.baseLinesVisible;
    }

    public void setBaseLinesVisible(boolean flag) {
        this.baseLinesVisible = flag;
    }

    public Shape getLegendLine() {
        return this.legendLine;
    }

    public void setLegendLine(Shape line) {
        if (line == null) {
            throw new IllegalArgumentException("Null 'line' argument.");
        }
        this.legendLine = line;
    }

    public boolean getItemShapeVisible(int series, int item) {
        Boolean flag = this.shapesVisible;
        if (flag == null) {
            flag = this.getSeriesShapesVisible(series);
        }
        if (flag != null) {
            return flag;
        }
        return this.baseShapesVisible;
    }

    public Boolean getShapesVisible() {
        return this.shapesVisible;
    }

    public void setShapesVisible(Boolean visible) {
        this.shapesVisible = visible;
    }

    public void setShapesVisible(boolean visible) {
        this.setShapesVisible(BooleanUtilities.valueOf(visible));
    }

    public Boolean getSeriesShapesVisible(int series) {
        return this.seriesShapesVisible.getBoolean(series);
    }

    public void setSeriesShapesVisible(int series, boolean visible) {
        this.setSeriesShapesVisible(series, BooleanUtilities.valueOf(visible));
    }

    public void setSeriesShapesVisible(int series, Boolean flag) {
        this.seriesShapesVisible.setBoolean(series, flag);
    }

    public boolean getBaseShapesVisible() {
        return this.baseShapesVisible;
    }

    public void setBaseShapesVisible(boolean flag) {
        this.baseShapesVisible = flag;
    }

    public boolean getItemShapeFilled(int series, int item) {
        Boolean flag = this.shapesFilled;
        if (flag == null) {
            flag = this.getSeriesShapesFilled(series);
        }
        if (flag != null) {
            return flag;
        }
        return this.baseShapesFilled;
    }

    public void setShapesFilled(boolean filled) {
        this.setShapesFilled(BooleanUtilities.valueOf(filled));
    }

    public void setShapesFilled(Boolean filled) {
        this.shapesFilled = filled;
    }

    public Boolean getSeriesShapesFilled(int series) {
        return this.seriesShapesFilled.getBoolean(series);
    }

    public void setSeriesShapesFilled(int series, boolean flag) {
        this.setSeriesShapesFilled(series, BooleanUtilities.valueOf(flag));
    }

    public void setSeriesShapesFilled(int series, Boolean flag) {
        this.seriesShapesFilled.setBoolean(series, flag);
    }

    public boolean getBaseShapesFilled() {
        return this.baseShapesFilled;
    }

    public void setBaseShapesFilled(boolean flag) {
        this.baseShapesFilled = flag;
    }

    public boolean getDrawOutlines() {
        return this.drawOutlines;
    }

    public void setDrawOutlines(boolean flag) {
        this.drawOutlines = flag;
    }

    public boolean getUseFillPaint() {
        return this.useFillPaint;
    }

    public void setUseFillPaint(boolean flag) {
        this.useFillPaint = flag;
    }

    public boolean getUseOutlinePaint() {
        return this.useOutlinePaint;
    }

    public void setUseOutlinePaint(boolean flag) {
        this.useOutlinePaint = flag;
    }

    @Override
    public XYItemRendererState initialise(Canvas g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        State state = new State(info);
        state.seriesPath = new GeneralPath();
        return state;
    }

    @Override
    public void drawItem(Canvas g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        if (!this.getItemVisible(series, item)) {
            return;
        }
        if (this.isLinePass(pass)) {
            if (this.getItemLineVisible(series, item)) {
                if (this.drawSeriesLineAsPath) {
                    this.drawPrimaryLineAsPath(state, g2, plot, dataset, pass, series, item, domainAxis, rangeAxis, dataArea);
                } else {
                    this.drawPrimaryLine(state, g2, plot, dataset, pass, series, item, domainAxis, rangeAxis, dataArea);
                }
            }
        } else if (this.isItemPass(pass)) {
            EntityCollection entities = null;
            if (info != null) {
                entities = info.getOwner().getEntityCollection();
            }
            this.drawSecondaryPass(g2, plot, dataset, pass, series, item, domainAxis, dataArea, rangeAxis, crosshairState, entities);
        }
    }

    protected boolean isLinePass(int pass) {
        return pass == 0;
    }

    protected boolean isItemPass(int pass) {
        return pass == 1;
    }

    protected void drawPrimaryLine(XYItemRendererState state, Canvas g2, XYPlot plot, XYDataset dataset, int pass, int series, int item, ValueAxis domainAxis, ValueAxis rangeAxis, Rectangle2D dataArea) {
        if (item == 0) {
            return;
        }
        double x1 = dataset.getXValue(series, item);
        double y1 = dataset.getYValue(series, item);
        if (Double.isNaN(y1) || Double.isNaN(x1)) {
            return;
        }
        double x0 = dataset.getXValue(series, item - 1);
        double y0 = dataset.getYValue(series, item - 1);
        if (Double.isNaN(y0) || Double.isNaN(x0)) {
            return;
        }
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double transX0 = domainAxis.valueToJava2D(x0, dataArea, xAxisLocation);
        double transY0 = rangeAxis.valueToJava2D(y0, dataArea, yAxisLocation);
        double transX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double transY1 = rangeAxis.valueToJava2D(y1, dataArea, yAxisLocation);
        if (Double.isNaN(transX0) || Double.isNaN(transY0) || Double.isNaN(transX1) || Double.isNaN(transY1)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            state.workingLine.setLine(transY0, transX0, transY1, transX1);
        } else if (orientation == PlotOrientation.VERTICAL) {
            state.workingLine.setLine(transX0, transY0, transX1, transY1);
        }
        if (state.workingLine.intersects(dataArea)) {
            this.drawFirstPassShape(g2, pass, series, item, state.workingLine);
        }
    }

    protected void drawFirstPassShape(Canvas g2, int pass, int series, int item, Shape shape) {
        Paint p = this.getItemPaint(series, item);
        p.setStyle(Paint.Style.STROKE);
        p.setStrokeWidth(this.getItemStroke(series, item).floatValue());
        Path path = this.convertAwtPathToAndroid(shape.getPathIterator(null));
        g2.drawPath(path, p);
    }

    protected void drawPrimaryLineAsPath(XYItemRendererState state, Canvas g2, XYPlot plot, XYDataset dataset, int pass, int series, int item, ValueAxis domainAxis, ValueAxis rangeAxis, Rectangle2D dataArea) {
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double x1 = dataset.getXValue(series, item);
        double y1 = dataset.getYValue(series, item);
        double transX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double transY1 = rangeAxis.valueToJava2D(y1, dataArea, yAxisLocation);
        State s = (State)state;
        if (!Double.isNaN(transX1) && !Double.isNaN(transY1)) {
            float x = (float)transX1;
            float y = (float)transY1;
            PlotOrientation orientation = plot.getOrientation();
            if (orientation == PlotOrientation.HORIZONTAL) {
                x = (float)transY1;
                y = (float)transX1;
            }
            if (s.isLastPointGood()) {
                s.seriesPath.lineTo(x, y);
            } else {
                s.seriesPath.moveTo(x, y);
            }
            s.setLastPointGood(true);
        } else {
            s.setLastPointGood(false);
        }
        if (item == s.getLastItemIndex()) {
            this.drawFirstPassShape(g2, pass, series, item, s.seriesPath);
        }
    }

    protected void drawSecondaryPass(Canvas g2, XYPlot plot, XYDataset dataset, int pass, int series, int item, ValueAxis domainAxis, Rectangle2D dataArea, ValueAxis rangeAxis, CrosshairState crosshairState, EntityCollection entities) {
        Shape entityArea = null;
        double x1 = dataset.getXValue(series, item);
        double y1 = dataset.getYValue(series, item);
        if (Double.isNaN(y1) || Double.isNaN(x1)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double transX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double transY1 = rangeAxis.valueToJava2D(y1, dataArea, yAxisLocation);
        if (this.getItemShapeVisible(series, item)) {
            Shape shape = this.getItemShape(series, item);
            if (orientation == PlotOrientation.HORIZONTAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, transY1, transX1);
            } else if (orientation == PlotOrientation.VERTICAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, transX1, transY1);
            }
            entityArea = shape;
            if (shape.intersects(dataArea)) {
                Path path;
                Paint p;
                if (this.getItemShapeFilled(series, item)) {
                    p = this.useFillPaint ? this.getItemFillPaint(series, item) : this.getItemPaint(series, item);
                    p.setStyle(Paint.Style.FILL_AND_STROKE);
                    p.setStrokeWidth(this.getItemStroke(series, item).floatValue());
                    path = this.convertAwtPathToAndroid(shape.getPathIterator(null));
                    g2.drawPath(path, p);
                }
                if (this.drawOutlines) {
                    p = this.getUseOutlinePaint() ? this.getItemOutlinePaint(series, item) : this.getItemPaint(series, item);
                    p.setStyle(Paint.Style.STROKE);
                    p.setStrokeWidth(this.getItemStroke(series, item).floatValue());
                    path = this.convertAwtPathToAndroid(shape.getPathIterator(null));
                    g2.drawPath(path, p);
                }
            }
        }
        double xx = transX1;
        double yy = transY1;
        if (orientation == PlotOrientation.HORIZONTAL) {
            xx = transY1;
            yy = transX1;
        }
        if (this.isItemLabelVisible(series, item)) {
            this.drawItemLabel(g2, orientation, dataset, series, item, xx, yy, y1 < 0.0);
        }
        int domainAxisIndex = plot.getDomainAxisIndex(domainAxis);
        int rangeAxisIndex = plot.getRangeAxisIndex(rangeAxis);
        this.updateCrosshairValues(crosshairState, x1, y1, domainAxisIndex, rangeAxisIndex, transX1, transY1, orientation);
        if (entities != null && XYLineAndShapeRenderer.isPointInRect(dataArea, xx, yy)) {
            this.addEntity(entities, entityArea, dataset, series, item, xx, yy);
        }
    }

    @Override
    public LegendItem getLegendItem(int datasetIndex, int series) {
        XYPlot plot = this.getPlot();
        if (plot == null) {
            return null;
        }
        LegendItem result = null;
        XYDataset dataset = plot.getDataset(datasetIndex);
        if (dataset != null && this.getItemVisible(series, 0)) {
            String label;
            String description = label = this.getLegendItemLabelGenerator().generateLabel(dataset, series);
            boolean shapeIsVisible = this.getItemShapeVisible(series, 0);
            Shape shape = this.lookupLegendShape(series);
            boolean shapeIsFilled = this.getItemShapeFilled(series, 0);
            Paint fillPaint = this.useFillPaint ? this.lookupSeriesFillPaint(series) : this.lookupSeriesPaint(series);
            boolean shapeOutlineVisible = this.drawOutlines;
            Paint outlinePaint = this.useOutlinePaint ? this.lookupSeriesOutlinePaint(series) : this.lookupSeriesPaint(series);
            Float outlineStroke = this.lookupSeriesOutlineStroke(series);
            boolean lineVisible = this.getItemLineVisible(series, 0);
            Float lineStroke = Float.valueOf(this.lookupSeriesStroke(series));
            Paint linePaint = this.lookupSeriesPaint(series);
            result = new LegendItem(label, description, "", "", shapeIsVisible, shape, shapeIsFilled, fillPaint.getColor(), shapeOutlineVisible, outlinePaint.getColor(), outlineStroke.floatValue(), lineVisible, this.legendLine, lineStroke.floatValue(), linePaint.getColor());
            result.setLabelFont(this.lookupLegendTextFont(series));
            Paint labelPaint = this.lookupLegendTextPaint(series);
            if (labelPaint != null) {
                result.setLabelPaint(labelPaint);
            }
            result.setSeriesKey(dataset.getSeriesKey(series));
            result.setSeriesIndex(series);
            result.setDataset(dataset);
            result.setDatasetIndex(datasetIndex);
        }
        return result;
    }

    @Override
    public void addChangeListener(RendererChangeListener listener) {
    }

    @Override
    public Font getItemLabelFont() {
        return null;
    }

    @Override
    public Paint getItemLabelPaint() {
        return null;
    }

    @Override
    public ItemLabelPosition getNegativeItemLabelPosition() {
        return null;
    }

    @Override
    public ItemLabelPosition getPositiveItemLabelPosition() {
        return null;
    }

    @Override
    public Boolean getSeriesVisible() {
        return null;
    }

    @Override
    public Boolean getSeriesVisibleInLegend() {
        return null;
    }

    @Override
    public void removeChangeListener(RendererChangeListener listener) {
    }

    @Override
    public void setBaseOutlineStroke(Float stroke) {
    }

    @Override
    public void setBaseStroke(Float stroke) {
    }

    @Override
    public void setItemLabelFont(Font font) {
    }

    @Override
    public void setItemLabelGenerator(XYItemLabelGenerator generator) {
    }

    @Override
    public void setItemLabelPaint(Paint paint) {
    }

    @Override
    public void setItemLabelsVisible(boolean visible) {
    }

    @Override
    public void setItemLabelsVisible(Boolean visible) {
    }

    @Override
    public void setItemLabelsVisible(Boolean visible, boolean notify) {
    }

    @Override
    public void setNegativeItemLabelPosition(ItemLabelPosition position) {
    }

    @Override
    public void setNegativeItemLabelPosition(ItemLabelPosition position, boolean notify) {
    }

    @Override
    public void setOutlinePaint(Paint paint) {
    }

    @Override
    public void setOutlineStroke(Float stroke) {
    }

    @Override
    public void setPaint(Paint paint) {
    }

    @Override
    public void setPositiveItemLabelPosition(ItemLabelPosition position) {
    }

    @Override
    public void setPositiveItemLabelPosition(ItemLabelPosition position, boolean notify) {
    }

    @Override
    public void setSeriesOutlineStroke(int series, Float stroke) {
    }

    @Override
    public void setSeriesStroke(int series, Float stroke) {
    }

    @Override
    public void setSeriesVisible(Boolean visible) {
    }

    @Override
    public void setSeriesVisible(Boolean visible, boolean notify) {
    }

    @Override
    public void setSeriesVisibleInLegend(Boolean visible) {
    }

    @Override
    public void setSeriesVisibleInLegend(Boolean visible, boolean notify) {
    }

    @Override
    public void setShape(Shape shape) {
    }

    @Override
    public void setStroke(Float stroke) {
    }

    private Path convertAwtPathToAndroid(PathIterator pi) {
        Path path = new Path();
        float[] coords = new float[6];
        while (!pi.isDone()) {
            int windingRule = pi.getWindingRule();
            if (windingRule == 0) {
                path.setFillType(Path.FillType.EVEN_ODD);
            } else {
                path.setFillType(Path.FillType.INVERSE_EVEN_ODD);
            }
            int pathType = pi.currentSegment(coords);
            switch (pathType) {
                case 4: {
                    path.close();
                    break;
                }
                case 3: {
                    path.cubicTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 1: {
                    path.lineTo(coords[0], coords[1]);
                    break;
                }
                case 0: {
                    path.moveTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    path.quadTo(coords[0], coords[1], coords[2], coords[3]);
                }
            }
            pi.next();
        }
        return path;
    }

    public static class State
    extends XYItemRendererState {
        public GeneralPath seriesPath;
        private boolean lastPointGood;

        public State(PlotRenderingInfo info) {
            super(info);
        }

        public boolean isLastPointGood() {
            return this.lastPointGood;
        }

        public void setLastPointGood(boolean good) {
            this.lastPointGood = good;
        }

        @Override
        public void startSeriesPass(XYDataset dataset, int series, int firstItem, int lastItem, int pass, int passCount) {
            this.seriesPath.reset();
            this.lastPointGood = false;
            super.startSeriesPass(dataset, series, firstItem, lastItem, pass, passCount);
        }
    }
}

