/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.droidsolutions.droidcharts.core.entity.ChartEntity;
import net.droidsolutions.droidcharts.core.entity.EntityCollection;

public class StandardEntityCollection
implements EntityCollection,
Cloneable,
Serializable {
    private static final long serialVersionUID = 5384773031184897047L;
    private List entities = new ArrayList();

    @Override
    public int getEntityCount() {
        return this.entities.size();
    }

    @Override
    public ChartEntity getEntity(int index) {
        return (ChartEntity)this.entities.get(index);
    }

    @Override
    public void clear() {
        this.entities.clear();
    }

    @Override
    public void add(ChartEntity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Null 'entity' argument.");
        }
        this.entities.add(entity);
    }

    @Override
    public void addAll(EntityCollection collection) {
        this.entities.addAll(collection.getEntities());
    }

    @Override
    public ChartEntity getEntity(double x, double y) {
        int entityCount = this.entities.size();
        int i = entityCount - 1;
        while (i >= 0) {
            ChartEntity entity = (ChartEntity)this.entities.get(i);
            if (entity.getArea().contains(x, y)) {
                return entity;
            }
            --i;
        }
        return null;
    }

    @Override
    public Collection getEntities() {
        return Collections.unmodifiableCollection(this.entities);
    }

    @Override
    public Iterator iterator() {
        return this.entities.iterator();
    }
}

