/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import microsoft.mappoint.TileSystem;
import org.osmdroid.DefaultResourceProxyImpl;
import org.osmdroid.ResourceProxy;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileProviderBase;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.TileSourceFactory;
import org.osmdroid.util.MyMath;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.IOverlayMenuProvider;
import org.osmdroid.views.overlay.Overlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TilesOverlay
extends Overlay
implements IOverlayMenuProvider {
    private static final Logger logger = LoggerFactory.getLogger(TilesOverlay.class);
    public static final int MENU_MAP_MODE = TilesOverlay.getSafeMenuId();
    public static final int MENU_TILE_SOURCE_STARTING_ID = TilesOverlay.getSafeMenuIdSequence(TileSourceFactory.getTileSources().size());
    public static final int MENU_OFFLINE = TilesOverlay.getSafeMenuId();
    protected final MapTileProviderBase mTileProvider;
    protected final Paint mPaint = new Paint();
    private final Rect mTileRect = new Rect();
    private final Rect mViewPort = new Rect();
    private boolean mOptionsMenuEnabled = true;
    private int mWorldSize_2;
    private BitmapDrawable mLoadingTile = null;
    private int mLoadingBackgroundColor = Color.rgb((int)216, (int)208, (int)208);
    private int mLoadingLineColor = Color.rgb((int)200, (int)192, (int)192);

    public TilesOverlay(MapTileProviderBase aTileProvider, Context aContext) {
        this(aTileProvider, new DefaultResourceProxyImpl(aContext));
    }

    public TilesOverlay(MapTileProviderBase aTileProvider, ResourceProxy pResourceProxy) {
        super(pResourceProxy);
        if (aTileProvider == null) {
            throw new IllegalArgumentException("You must pass a valid tile provider to the tiles overlay.");
        }
        this.mTileProvider = aTileProvider;
    }

    @Override
    public void onDetach(MapView pMapView) {
        this.mTileProvider.detach();
    }

    public void setAlpha(int a) {
        this.mPaint.setAlpha(a);
    }

    public int getMinimumZoomLevel() {
        return this.mTileProvider.getMinimumZoomLevel();
    }

    public int getMaximumZoomLevel() {
        return this.mTileProvider.getMaximumZoomLevel();
    }

    public boolean useDataConnection() {
        return this.mTileProvider.useDataConnection();
    }

    public void setUseDataConnection(boolean aMode) {
        this.mTileProvider.setUseDataConnection(aMode);
    }

    @Override
    protected void draw(Canvas c, MapView osmv, boolean shadow) {
        if (shadow) {
            return;
        }
        MapView.Projection pj = osmv.getProjection();
        int zoomLevel = pj.getZoomLevel();
        this.mWorldSize_2 = TileSystem.MapSize(zoomLevel) / 2;
        this.mViewPort.set(pj.getScreenRect());
        this.mViewPort.offset(this.mWorldSize_2, this.mWorldSize_2);
        this.drawTiles(c, pj.getZoomLevel(), TileSystem.getTileSize(), this.mViewPort);
    }

    public void drawTiles(Canvas c, int zoomLevel, int tileSizePx, Rect viewPort) {
        Point upperLeft = TileSystem.PixelXYToTileXY(viewPort.left, viewPort.top, null);
        upperLeft.offset(-1, -1);
        Point lowerRight = TileSystem.PixelXYToTileXY(viewPort.right, viewPort.bottom, null);
        int mapTileUpperBound = 1 << zoomLevel;
        int numNeeded = (lowerRight.y - upperLeft.y + 1) * (lowerRight.x - upperLeft.x + 1);
        this.mTileProvider.ensureCapacity(numNeeded);
        for (int y = upperLeft.y; y <= lowerRight.y; ++y) {
            for (int x = upperLeft.x; x <= lowerRight.x; ++x) {
                int tileY = MyMath.mod(y, mapTileUpperBound);
                int tileX = MyMath.mod(x, mapTileUpperBound);
                MapTile tile = new MapTile(zoomLevel, tileX, tileY);
                Drawable currentMapTile = this.mTileProvider.getMapTile(tile);
                if (currentMapTile == null) {
                    currentMapTile = this.getLoadingTile();
                }
                if (currentMapTile == null) continue;
                this.mTileRect.set(x * tileSizePx, y * tileSizePx, x * tileSizePx + tileSizePx, y * tileSizePx + tileSizePx);
                this.onTileReadyToDraw(c, currentMapTile, this.mTileRect);
            }
        }
    }

    protected void onTileReadyToDraw(Canvas c, Drawable currentMapTile, Rect tileRect) {
        tileRect.offset(-this.mWorldSize_2, -this.mWorldSize_2);
        currentMapTile.setBounds(tileRect);
        currentMapTile.draw(c);
    }

    @Override
    public void setOptionsMenuEnabled(boolean pOptionsMenuEnabled) {
        this.mOptionsMenuEnabled = pOptionsMenuEnabled;
    }

    @Override
    public boolean isOptionsMenuEnabled() {
        return this.mOptionsMenuEnabled;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        SubMenu mapMenu = pMenu.addSubMenu(0, MENU_MAP_MODE + pMenuIdOffset, 0, (CharSequence)this.mResourceProxy.getString(ResourceProxy.string.map_mode)).setIcon(this.mResourceProxy.getDrawable(ResourceProxy.bitmap.ic_menu_mapmode));
        for (int a = 0; a < TileSourceFactory.getTileSources().size(); ++a) {
            ITileSource tileSource = TileSourceFactory.getTileSources().get(a);
            mapMenu.add(MENU_MAP_MODE + pMenuIdOffset, MENU_TILE_SOURCE_STARTING_ID + a + pMenuIdOffset, 0, (CharSequence)tileSource.localizedName(this.mResourceProxy));
        }
        mapMenu.setGroupCheckable(MENU_MAP_MODE + pMenuIdOffset, true, true);
        String title = pMapView.getResourceProxy().getString(pMapView.useDataConnection() ? ResourceProxy.string.offline_mode : ResourceProxy.string.online_mode);
        Drawable icon = pMapView.getResourceProxy().getDrawable(ResourceProxy.bitmap.ic_menu_offline);
        pMenu.add(0, MENU_OFFLINE + pMenuIdOffset, 0, (CharSequence)title).setIcon(icon);
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        int index = TileSourceFactory.getTileSources().indexOf(pMapView.getTileProvider().getTileSource());
        if (index >= 0) {
            pMenu.findItem(MENU_TILE_SOURCE_STARTING_ID + index + pMenuIdOffset).setChecked(true);
        }
        pMenu.findItem(MENU_OFFLINE + pMenuIdOffset).setTitle((CharSequence)pMapView.getResourceProxy().getString(pMapView.useDataConnection() ? ResourceProxy.string.offline_mode : ResourceProxy.string.online_mode));
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem pItem, int pMenuIdOffset, MapView pMapView) {
        int menuId = pItem.getItemId() - pMenuIdOffset;
        if (menuId >= MENU_TILE_SOURCE_STARTING_ID && menuId < MENU_TILE_SOURCE_STARTING_ID + TileSourceFactory.getTileSources().size()) {
            pMapView.setTileSource(TileSourceFactory.getTileSources().get(menuId - MENU_TILE_SOURCE_STARTING_ID));
            return true;
        }
        if (menuId == MENU_OFFLINE) {
            boolean useDataConnection = !pMapView.useDataConnection();
            pMapView.setUseDataConnection(useDataConnection);
            return true;
        }
        return false;
    }

    public int getLoadingBackgroundColor() {
        return this.mLoadingBackgroundColor;
    }

    public void setLoadingBackgroundColor(int pLoadingBackgroundColor) {
        if (this.mLoadingBackgroundColor != pLoadingBackgroundColor) {
            this.mLoadingBackgroundColor = pLoadingBackgroundColor;
            this.clearLoadingTile();
        }
    }

    public int getLoadingLineColor() {
        return this.mLoadingLineColor;
    }

    public void setLoadingLineColor(int pLoadingLineColor) {
        if (this.mLoadingLineColor != pLoadingLineColor) {
            this.mLoadingLineColor = pLoadingLineColor;
            this.clearLoadingTile();
        }
    }

    private Drawable getLoadingTile() {
        if (this.mLoadingTile == null && this.mLoadingBackgroundColor != 0) {
            try {
                int tileSize = this.mTileProvider.getTileSource() != null ? this.mTileProvider.getTileSource().getTileSizePixels() : 256;
                Bitmap bitmap2 = Bitmap.createBitmap((int)tileSize, (int)tileSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap2);
                Paint paint = new Paint();
                canvas.drawColor(this.mLoadingBackgroundColor);
                paint.setColor(this.mLoadingLineColor);
                paint.setStrokeWidth(0.0f);
                int lineSize = tileSize / 16;
                for (int a = 0; a < tileSize; a += lineSize) {
                    canvas.drawLine(0.0f, (float)a, (float)tileSize, (float)a, paint);
                    canvas.drawLine((float)a, 0.0f, (float)a, (float)tileSize, paint);
                }
                this.mLoadingTile = new BitmapDrawable(bitmap2);
            }
            catch (OutOfMemoryError e) {
                logger.error("OutOfMemoryError getting loading tile");
                System.gc();
            }
        }
        return this.mLoadingTile;
    }

    private void clearLoadingTile() {
        BitmapDrawable bitmapDrawable = this.mLoadingTile;
        this.mLoadingTile = null;
        if (bitmapDrawable != null) {
            bitmapDrawable.getBitmap().recycle();
        }
    }
}

