/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtils {
    private static final Logger logger = LoggerFactory.getLogger(StreamUtils.class);
    public static final int IO_BUFFER_SIZE = 8192;

    private StreamUtils() {
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        int read;
        long length = 0L;
        byte[] b = new byte[8192];
        while ((read = in.read(b)) != -1) {
            out.write(b, 0, read);
            length += (long)read;
        }
        return length;
    }

    public static void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.error("IO", (Object)"Could not close stream", (Object)e);
            }
        }
    }
}

