/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import org.osmdroid.DefaultResourceProxyImpl;
import org.osmdroid.ResourceProxy;

public class ItemizedOverlayControlView
extends LinearLayout {
    protected ImageButton mPreviousButton;
    protected ImageButton mNextButton;
    protected ImageButton mCenterToButton;
    protected ImageButton mNavToButton;
    protected ItemizedOverlayControlViewListener mLis;

    public ItemizedOverlayControlView(Context context, AttributeSet attrs) {
        this(context, attrs, new DefaultResourceProxyImpl(context));
    }

    public ItemizedOverlayControlView(Context context, AttributeSet attrs, ResourceProxy pResourceProxy) {
        super(context, attrs);
        this.mPreviousButton = new ImageButton(context);
        this.mPreviousButton.setImageBitmap(pResourceProxy.getBitmap(ResourceProxy.bitmap.previous));
        this.mNextButton = new ImageButton(context);
        this.mNextButton.setImageBitmap(pResourceProxy.getBitmap(ResourceProxy.bitmap.next));
        this.mCenterToButton = new ImageButton(context);
        this.mCenterToButton.setImageBitmap(pResourceProxy.getBitmap(ResourceProxy.bitmap.center));
        this.mNavToButton = new ImageButton(context);
        this.mNavToButton.setImageBitmap(pResourceProxy.getBitmap(ResourceProxy.bitmap.navto_small));
        this.addView((View)this.mPreviousButton, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.addView((View)this.mCenterToButton, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.addView((View)this.mNavToButton, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.addView((View)this.mNextButton, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.initViewListeners();
    }

    public void setItemizedOverlayControlViewListener(ItemizedOverlayControlViewListener lis) {
        this.mLis = lis;
    }

    public void setNextEnabled(boolean pEnabled) {
        this.mNextButton.setEnabled(pEnabled);
    }

    public void setPreviousEnabled(boolean pEnabled) {
        this.mPreviousButton.setEnabled(pEnabled);
    }

    public void setNavToVisible(int pVisibility) {
        this.mNavToButton.setVisibility(pVisibility);
    }

    private void initViewListeners() {
        this.mNextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ItemizedOverlayControlView.this.mLis != null) {
                    ItemizedOverlayControlView.this.mLis.onNext();
                }
            }
        });
        this.mPreviousButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ItemizedOverlayControlView.this.mLis != null) {
                    ItemizedOverlayControlView.this.mLis.onPrevious();
                }
            }
        });
        this.mCenterToButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ItemizedOverlayControlView.this.mLis != null) {
                    ItemizedOverlayControlView.this.mLis.onCenter();
                }
            }
        });
        this.mNavToButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ItemizedOverlayControlView.this.mLis != null) {
                    ItemizedOverlayControlView.this.mLis.onNavTo();
                }
            }
        });
    }

    public static interface ItemizedOverlayControlViewListener {
        public void onPrevious();

        public void onNext();

        public void onCenter();

        public void onNavTo();
    }
}

