/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.contributor.util;

import org.osmdroid.contributor.util.constants.OpenStreetMapContributorConstants;
import org.osmdroid.util.GeoPoint;

public class RecordedGeoPoint
extends GeoPoint
implements OpenStreetMapContributorConstants {
    private static final long serialVersionUID = 7304941424576720318L;
    protected final long mTimeStamp;
    protected final int mNumSatellites;

    public RecordedGeoPoint(int latitudeE6, int longitudeE6) {
        this(latitudeE6, longitudeE6, System.currentTimeMillis(), Integer.MIN_VALUE);
    }

    public RecordedGeoPoint(int latitudeE6, int longitudeE6, long aTimeStamp, int aNumSatellites) {
        super(latitudeE6, longitudeE6);
        this.mTimeStamp = aTimeStamp;
        this.mNumSatellites = aNumSatellites;
    }

    public long getTimeStamp() {
        return this.mTimeStamp;
    }

    public double getLatitudeAsDouble() {
        return (double)this.getLatitudeE6() / 1000000.0;
    }

    public double getLongitudeAsDouble() {
        return (double)this.getLongitudeE6() / 1000000.0;
    }

    public int getNumSatellites() {
        return this.mNumSatellites;
    }
}

