/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.data;

import java.io.InvalidObjectException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import net.droidsolutions.droidcharts.common.SortOrder;
import net.droidsolutions.droidcharts.core.data.DefaultKeyedValues;
import net.droidsolutions.droidcharts.core.data.KeyedValues;
import net.droidsolutions.droidcharts.core.data.PieDataset;
import net.droidsolutions.droidcharts.core.data.general.AbstractDataset;

public class DefaultPieDataset
extends AbstractDataset
implements PieDataset,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2904745139106540618L;
    private DefaultKeyedValues data;

    public DefaultPieDataset() {
        this.data = new DefaultKeyedValues();
    }

    public DefaultPieDataset(KeyedValues data) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        this.data = new DefaultKeyedValues();
        int i = 0;
        while (i < data.getItemCount()) {
            this.data.addValue(data.getKey(i), data.getValue(i));
            ++i;
        }
    }

    @Override
    public int getItemCount() {
        return this.data.getItemCount();
    }

    @Override
    public List getKeys() {
        return Collections.unmodifiableList(this.data.getKeys());
    }

    @Override
    public Comparable getKey(int item) {
        return this.data.getKey(item);
    }

    @Override
    public int getIndex(Comparable key) {
        return this.data.getIndex(key);
    }

    @Override
    public Number getValue(int item) {
        Number result = null;
        if (this.getItemCount() > item) {
            result = this.data.getValue(item);
        }
        return result;
    }

    @Override
    public Number getValue(Comparable key) {
        if (key == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        return this.data.getValue(key);
    }

    public void setValue(Comparable key, Number value) {
        this.data.setValue(key, value);
    }

    public void setValue(Comparable key, double value) {
        this.setValue(key, new Double(value));
    }

    public void insertValue(int position, Comparable key, double value) {
        this.insertValue(position, key, new Double(value));
    }

    public void insertValue(int position, Comparable key, Number value) {
        this.data.insertValue(position, key, value);
    }

    public void remove(Comparable key) {
        this.data.removeValue(key);
    }

    public void clear() {
        if (this.getItemCount() > 0) {
            this.data.clear();
        }
    }

    public void sortByKeys(SortOrder order) {
        this.data.sortByKeys(order);
    }

    public void sortByValues(SortOrder order) {
        this.data.sortByValues(order);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PieDataset)) {
            return false;
        }
        PieDataset that = (PieDataset)obj;
        int count = this.getItemCount();
        if (that.getItemCount() != count) {
            return false;
        }
        int i = 0;
        while (i < count) {
            Comparable k2;
            Comparable k1 = this.getKey(i);
            if (!k1.equals(k2 = that.getKey(i))) {
                return false;
            }
            Number v1 = this.getValue(i);
            Number v2 = that.getValue(i);
            if (v1 == null ? v2 != null : !v1.equals(v2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultPieDataset clone = (DefaultPieDataset)super.clone();
        clone.data = (DefaultKeyedValues)this.data.clone();
        return clone;
    }

    @Override
    public void validateObject() throws InvalidObjectException {
    }
}

