/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.view.View;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.core.ChartFactory;
import net.droidsolutions.droidcharts.core.JFreeChart;
import net.droidsolutions.droidcharts.core.axis.CategoryAxis;
import net.droidsolutions.droidcharts.core.axis.CategoryLabelPositions;
import net.droidsolutions.droidcharts.core.axis.NumberAxis;
import net.droidsolutions.droidcharts.core.data.CategoryDataset;
import net.droidsolutions.droidcharts.core.data.DefaultCategoryDataset;
import net.droidsolutions.droidcharts.core.plot.CategoryPlot;
import net.droidsolutions.droidcharts.core.plot.PlotOrientation;
import net.droidsolutions.droidcharts.core.renderer.category.LineAndShapeRenderer;

public class LineChartExampleView
extends View {
    private Rect mRect = new Rect();
    private Handler mHandler = new Handler();

    public LineChartExampleView(Context context) {
        super(context);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.getClipBounds(this.mRect);
        CategoryDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        chart.draw(canvas, new Rectangle2D.Double(0.0, 0.0, this.mRect.width(), this.mRect.height()));
        Paint p = new Paint();
        p.setColor(-65536);
    }

    public void repaint() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                LineChartExampleView.this.invalidate();
            }
        });
    }

    private CategoryDataset createDataset() {
        String series1 = "First";
        String series2 = "Second";
        String series3 = "Third";
        String type1 = "Type 1";
        String type2 = "Type 2";
        String type3 = "Type 3";
        String type4 = "Type 4";
        String type5 = "Type 5";
        String type6 = "Type 6";
        String type7 = "Type 7";
        String type8 = "Type 8";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(1.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 1"));
        dataset.addValue(4.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 2"));
        dataset.addValue(3.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 3"));
        dataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 4"));
        dataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 5"));
        dataset.addValue(7.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 6"));
        dataset.addValue(7.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 7"));
        dataset.addValue(8.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 8"));
        dataset.addValue(5.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 1"));
        dataset.addValue(7.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 2"));
        dataset.addValue(6.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 3"));
        dataset.addValue(8.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 4"));
        dataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 5"));
        dataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 6"));
        dataset.addValue(2.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 7"));
        dataset.addValue(1.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 8"));
        dataset.addValue(4.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 1"));
        dataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 2"));
        dataset.addValue(2.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 3"));
        dataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 4"));
        dataset.addValue(6.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 5"));
        dataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 6"));
        dataset.addValue(4.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 7"));
        dataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 8"));
        return dataset;
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart("Line Chart Demo 5", "Type", "Value", dataset, PlotOrientation.VERTICAL, true, true, false);
        Paint white = new Paint(1);
        white.setColor(-1);
        Paint dkGray = new Paint(1);
        dkGray.setColor(-12303292);
        Paint lightGray = new Paint(1);
        lightGray.setColor(-3355444);
        lightGray.setStrokeWidth(10.0f);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint(dkGray);
        plot.setDomainGridlinePaint(lightGray);
        plot.setRangeGridlinePaint(lightGray);
        plot.setDomainGridlinesVisible(true);
        chart.setBackgroundPaint(white);
        Paint blue = new Paint(1);
        blue.setColor(Color.rgb((int)125, (int)138, (int)46));
        blue.setAlpha(200);
        blue.setStrokeWidth(10.0f);
        Paint green = new Paint(1);
        green.setColor(Color.rgb((int)255, (int)240, (int)165));
        green.setAlpha(200);
        Paint red = new Paint(1);
        red.setColor(Color.rgb((int)182, (int)73, (int)38));
        red.setAlpha(200);
        plot.getRenderer().setSeriesPaint(0, blue);
        plot.getRenderer().setSeriesPaint(1, green);
        plot.getRenderer().setSeriesPaint(2, red);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setItemLabelsVisible(true);
        renderer.setSeriesShapesVisible(0, true);
        renderer.setSeriesShapesVisible(1, true);
        renderer.setSeriesShapesVisible(2, true);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setAutoRangeIncludesZero(false);
        rangeAxis.setUpperMargin(0.12);
        rangeAxis.setLabelAngle(90.0);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.STANDARD);
        return chart;
    }
}

