/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import java.util.TimeZone;
import org.apache.cordova.api.CordovaInterface;
import org.apache.cordova.api.LOG;
import org.apache.cordova.api.Plugin;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Device
extends Plugin {
    public static final String TAG = "Device";
    public static String cordovaVersion = "1.5.0";
    public static String platform = "Android";
    public static String uuid;
    BroadcastReceiver telephonyReceiver = null;

    public void setContext(CordovaInterface ctx) {
        super.setContext(ctx);
        uuid = this.getUuid();
        this.initTelephonyReceiver();
    }

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        try {
            if (action.equals("getDeviceInfo")) {
                JSONObject r = new JSONObject();
                r.put("uuid", (Object)uuid);
                r.put("version", (Object)this.getOSVersion());
                r.put("platform", (Object)platform);
                r.put("name", (Object)this.getProductName());
                r.put("cordova", (Object)cordovaVersion);
                return new PluginResult(status, r);
            }
            return new PluginResult(status, result);
        }
        catch (JSONException e) {
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
    }

    public boolean isSynch(String action) {
        return action.equals("getDeviceInfo");
    }

    public void onDestroy() {
        this.ctx.unregisterReceiver(this.telephonyReceiver);
    }

    private void initTelephonyReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PHONE_STATE");
        final CordovaInterface myctx = this.ctx;
        this.telephonyReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent != null && intent.getAction().equals("android.intent.action.PHONE_STATE") && intent.hasExtra("state")) {
                    String extraData = intent.getStringExtra("state");
                    if (extraData.equals(TelephonyManager.EXTRA_STATE_RINGING)) {
                        LOG.i(Device.TAG, "Telephone RINGING");
                        myctx.postMessage("telephone", "ringing");
                    } else if (extraData.equals(TelephonyManager.EXTRA_STATE_OFFHOOK)) {
                        LOG.i(Device.TAG, "Telephone OFFHOOK");
                        myctx.postMessage("telephone", "offhook");
                    } else if (extraData.equals(TelephonyManager.EXTRA_STATE_IDLE)) {
                        LOG.i(Device.TAG, "Telephone IDLE");
                        myctx.postMessage("telephone", "idle");
                    }
                }
            }
        };
        this.ctx.registerReceiver(this.telephonyReceiver, intentFilter);
    }

    public String getPlatform() {
        return platform;
    }

    public String getUuid() {
        String uuid = Settings.Secure.getString((ContentResolver)this.ctx.getContentResolver(), (String)"android_id");
        return uuid;
    }

    public String getCordovaVersion() {
        return cordovaVersion;
    }

    public String getModel() {
        String model = Build.MODEL;
        return model;
    }

    public String getProductName() {
        String productname = Build.PRODUCT;
        return productname;
    }

    public String getOSVersion() {
        String osversion = Build.VERSION.RELEASE;
        return osversion;
    }

    public String getSDKVersion() {
        String sdkversion = Build.VERSION.SDK;
        return sdkversion;
    }

    public String getTimeZoneID() {
        TimeZone tz = TimeZone.getDefault();
        return tz.getID();
    }
}

