/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import java.util.ArrayList;
import org.osmdroid.DefaultResourceProxyImpl;
import org.osmdroid.ResourceProxy;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;

public class PathOverlay
extends Overlay {
    private ArrayList<Point> mPoints;
    private int mPointsPrecomputed;
    protected Paint mPaint = new Paint();
    private final Path mPath = new Path();
    private final Point mTempPoint1 = new Point();
    private final Point mTempPoint2 = new Point();
    private final Rect mLineBounds = new Rect();

    public PathOverlay(int color, Context ctx) {
        this(color, new DefaultResourceProxyImpl(ctx));
    }

    public PathOverlay(int color, ResourceProxy pResourceProxy) {
        super(pResourceProxy);
        this.mPaint.setColor(color);
        this.mPaint.setStrokeWidth(2.0f);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.clearPath();
    }

    public void setColor(int color) {
        this.mPaint.setColor(color);
    }

    public void setAlpha(int a) {
        this.mPaint.setAlpha(a);
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    public void setPaint(Paint pPaint) {
        if (pPaint == null) {
            throw new IllegalArgumentException("pPaint argument cannot be null");
        }
        this.mPaint = pPaint;
    }

    public void clearPath() {
        this.mPoints = new ArrayList();
        this.mPointsPrecomputed = 0;
    }

    public void addPoint(GeoPoint pt) {
        this.addPoint(pt.getLatitudeE6(), pt.getLongitudeE6());
    }

    public void addPoint(int latitudeE6, int longitudeE6) {
        this.mPoints.add(new Point(latitudeE6, longitudeE6));
    }

    public int getNumberOfPoints() {
        return this.mPoints.size();
    }

    @Override
    protected void draw(Canvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        if (this.mPoints.size() < 2) {
            return;
        }
        MapView.Projection pj = mapView.getProjection();
        int size = this.mPoints.size();
        while (this.mPointsPrecomputed < size) {
            Point pt = this.mPoints.get(this.mPointsPrecomputed);
            pj.toMapPixelsProjected(pt.x, pt.y, pt);
            ++this.mPointsPrecomputed;
        }
        Point screenPoint0 = null;
        Point screenPoint1 = null;
        Rect clipBounds = pj.fromPixelsToProjected(pj.getScreenRect());
        this.mPath.rewind();
        Point projectedPoint0 = this.mPoints.get(size - 1);
        this.mLineBounds.set(projectedPoint0.x, projectedPoint0.y, projectedPoint0.x, projectedPoint0.y);
        for (int i = size - 2; i >= 0; --i) {
            Point projectedPoint1 = this.mPoints.get(i);
            this.mLineBounds.union(projectedPoint1.x, projectedPoint1.y);
            if (!Rect.intersects((Rect)clipBounds, (Rect)this.mLineBounds)) {
                projectedPoint0 = projectedPoint1;
                screenPoint0 = null;
                continue;
            }
            if (screenPoint0 == null) {
                screenPoint0 = pj.toMapPixelsTranslated(projectedPoint0, this.mTempPoint1);
                this.mPath.moveTo((float)screenPoint0.x, (float)screenPoint0.y);
            }
            screenPoint1 = pj.toMapPixelsTranslated(projectedPoint1, this.mTempPoint2);
            if (Math.abs(screenPoint1.x - screenPoint0.x) + Math.abs(screenPoint1.y - screenPoint0.y) <= 1) continue;
            this.mPath.lineTo((float)screenPoint1.x, (float)screenPoint1.y);
            projectedPoint0 = projectedPoint1;
            screenPoint0.x = screenPoint1.x;
            screenPoint0.y = screenPoint1.y;
            this.mLineBounds.set(projectedPoint0.x, projectedPoint0.y, projectedPoint0.x, projectedPoint0.y);
        }
        canvas.drawPath(this.mPath, this.mPaint);
    }
}

