package com.eat.chapter7;

import android.app.Activity;
import android.app.Fragment;
import android.os.Bundle;
import android.os.SystemClock;

public class ThreadFragment extends Fragment {

    private ThreadRetainWithFragmentActivity mActivity;
    private MyThread t;

    private class MyThread extends Thread {

        @Override
        public void run() {
            final String text = getTextFromNetwork();
            mActivity.setText(text);
        }

        // Długa operacja
        private String getTextFromNetwork() {
            // Symulowanie operacji sieciowej
            SystemClock.sleep(5000);
            return "Tekst z sieci";
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setRetainInstance(true);
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        mActivity = (ThreadRetainWithFragmentActivity) activity;
    }

    @Override
    public void onDetach() {
        super.onDetach();
        mActivity = null;
    }

    public void execute() {
        t = new MyThread();
        t.start();
    }
}
