package com.eat.chapter12;

import android.app.IntentService;
import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;

import com.eat.R;


public class NetworkCheckerIntentService extends IntentService {

    public NetworkCheckerIntentService() {
        super("NetworkCheckerThread");
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        if (isNewNetworkDataAvailable()) {
            addStatusBarNotification();
        }
    }

    private boolean isNewNetworkDataAvailable() {
        // Pominięty kod żądania sieciowego. Zwracanie atrapy rezultatu.
        return true;
    }

    private void addStatusBarNotification() {
        Notification.Builder mBuilder =
                new Notification.Builder(this)
                        .setSmallIcon(R.drawable.ic_launcher)
                        .setContentTitle("Nowe dane sieciowe.")
                        .setContentText("Nowe dane mogą zostać pobrane.");

        NotificationManager mNotificationManager =
                (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
        mNotificationManager.notify(1, mBuilder.build());
    }


}
