package com.manning.unlockingandroid;

import java.text.NumberFormat;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

public class ChapterTwo extends Activity {

    public static final String tag = "Rozdzia2";

    @Override
    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        setContentView(R.layout.main);
        final EditText mealpricefield = 
                    (EditText) findViewById(R.id.mealprice);
        final TextView answerfield = 
                    (TextView) findViewById(R.id.answer);
        final Button button = (Button) findViewById(R.id.calculate);
        button.setOnClickListener(new Button.OnClickListener() {
            public void onClick(View v) {
                 try {
                  Log.i(tag,"Wywoane onClick.");
                   // pobierz cen potrawy z UI
                   String mealprice = 
                   mealpricefield.getText().toString();
                   Log.i(tag,"Cena potrawy to [" + mealprice + "]");
                   String answer = "";
                   // sprawd, czy cena potrawy zawiera "$"
                   if (mealprice.indexOf("$") == -1) {
                      mealprice = "$" + mealprice;
                   }
                   float fmp = 0.0F;
                   // pobierz formater walut
                   NumberFormat nf =        
                   java.text.NumberFormat.getCurrencyInstance();
                   // pobierz cen wejciow potrawy
                   fmp = nf.parse(mealprice).floatValue();
                   // dajmy solidny napiwek -> 20%
                   fmp *= 1.2;
                   Log.i(tag,"Cakowita cena potrawy (niesformatowana) to [" + fmp + "]");
                   // formatowanie wynikw
                   answer = "Pena cena z 20% napiwkiem: " + nf.format(fmp);
                   answerfield.setText(answer);
                   Log.i(tag,"Zakoczone onClick.");
                } catch (java.text.ParseException pe) {
                  Log.i(tag,"Przechwycono wyjtek analizy");
                  answerfield.setText("Nieudana analiza wartoci");
                } catch (Exception e)    {
                  Log.e(tag,"Nieudane obliczenie napiwku:" + e.getMessage());
                  e.printStackTrace();
                  answerfield.setText(e.getMessage());
                }
            }
        });
    }
}
