/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.client.oauth;

import com.google.code.linkedinapi.client.oauth.LinkedInApiConsumer;
import com.google.code.linkedinapi.client.oauth.LinkedInOAuthService;
import com.google.code.linkedinapi.client.oauth.LinkedInOAuthServiceImpl;

public class LinkedInOAuthServiceFactory {
    private static LinkedInOAuthServiceFactory instance;

    private LinkedInOAuthServiceFactory() {
    }

    public static synchronized LinkedInOAuthServiceFactory getInstance() {
        if (instance == null) {
            instance = new LinkedInOAuthServiceFactory();
        }
        return instance;
    }

    public LinkedInOAuthService createLinkedInOAuthService(String consumerKey, String consumerSecret) {
        return this.createLinkedInOAuthService(new LinkedInApiConsumer(consumerKey, consumerSecret));
    }

    public LinkedInOAuthService createLinkedInOAuthService(LinkedInApiConsumer apiConsumer) {
        this.validateConsumerKey(apiConsumer);
        return new LinkedInOAuthServiceImpl(apiConsumer);
    }

    private void validateConsumerKey(LinkedInApiConsumer apiConsumer) {
        if (apiConsumer == null) {
            throw new IllegalArgumentException("api consumer cannot be null.");
        }
        if (apiConsumer.getConsumerKey() == null || apiConsumer.getConsumerKey().length() == 0) {
            throw new IllegalArgumentException("consumer key cannot be null or empty.");
        }
        if (apiConsumer.getConsumerSecret() == null || apiConsumer.getConsumerSecret().length() == 0) {
            throw new IllegalArgumentException("consumer secret cannot be null or empty.");
        }
    }
}

