/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.client.enumeration;

import com.google.code.linkedinapi.client.enumeration.FieldEnum;
import com.google.code.linkedinapi.client.enumeration.SearchEnum;
import com.google.code.linkedinapi.client.enumeration.SearchScope;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum SearchParameter implements FieldEnum,
SearchEnum
{
    KEYWORDS("keywords", (Set<SearchScope>)EnumSet.of(SearchScope.PEOPLE, SearchScope.COMPANIES, SearchScope.JOBS)),
    FIRST_NAME("first-name", (Set<SearchScope>)EnumSet.of(SearchScope.PEOPLE)),
    LAST_NAME("last-name", (Set<SearchScope>)EnumSet.of(SearchScope.PEOPLE)),
    COMPANY_NAME("company-name", (Set<SearchScope>)EnumSet.of(SearchScope.PEOPLE, SearchScope.JOBS)),
    CURRENT_COMPANY("current-company", (Set<SearchScope>)EnumSet.of(SearchScope.PEOPLE)),
    TITLE("title", (Set<SearchScope>)EnumSet.of(SearchScope.PEOPLE)),
    CURRENT_TITLE("current-title", (Set<SearchScope>)EnumSet.of(SearchScope.PEOPLE)),
    SCHOOL_NAME("school-name", (Set<SearchScope>)EnumSet.of(SearchScope.PEOPLE)),
    CURRENT_SCHOOL("current-school", (Set<SearchScope>)EnumSet.of(SearchScope.PEOPLE)),
    COUNTRY_CODE("country-code", (Set<SearchScope>)EnumSet.of(SearchScope.PEOPLE, SearchScope.JOBS)),
    POSTAL_CODE("postal-code", (Set<SearchScope>)EnumSet.of(SearchScope.PEOPLE, SearchScope.JOBS)),
    DISTANCE("distance", (Set<SearchScope>)EnumSet.of(SearchScope.PEOPLE, SearchScope.JOBS)),
    HEADQUARTER("hq-only", (Set<SearchScope>)EnumSet.of(SearchScope.COMPANIES)),
    JOB_TITLE("job-title", (Set<SearchScope>)EnumSet.of(SearchScope.JOBS)),
    FACET("facet", (Set<SearchScope>)EnumSet.of(SearchScope.PEOPLE, SearchScope.COMPANIES, SearchScope.JOBS)),
    FACETS("facets", (Set<SearchScope>)EnumSet.of(SearchScope.PEOPLE, SearchScope.COMPANIES, SearchScope.JOBS));

    private static final Map<String, SearchParameter> stringToEnum;
    private final String fieldName;
    private final Set<SearchScope> scopes;

    static {
        stringToEnum = new HashMap<String, SearchParameter>();
        SearchParameter[] searchParameterArray = SearchParameter.values();
        int n = searchParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchParameter op = searchParameterArray[n2];
            stringToEnum.put(op.fieldName(), op);
            ++n2;
        }
    }

    private SearchParameter(String name, Set<SearchScope> scopes) {
        this.fieldName = name;
        this.scopes = scopes;
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    public String toString() {
        return this.fieldName();
    }

    @Override
    public boolean hasScope(SearchScope scope) {
        return this.scopes.contains(scope);
    }

    public static SearchParameter fromString(String symbol) {
        return stringToEnum.get(symbol);
    }
}

