/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.client.oauth;

import com.google.code.linkedinapi.client.constant.ApplicationConstants;
import com.google.code.linkedinapi.client.constant.LinkedInApiUrls;
import com.google.code.linkedinapi.client.oauth.LinkedInAccessToken;
import com.google.code.linkedinapi.client.oauth.LinkedInApiConsumer;
import com.google.code.linkedinapi.client.oauth.LinkedInOAuthService;
import com.google.code.linkedinapi.client.oauth.LinkedInOAuthServiceException;
import com.google.code.linkedinapi.client.oauth.LinkedInOAuthToken;
import com.google.code.linkedinapi.client.oauth.LinkedInRequestToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.basic.DefaultOAuthProvider;
import oauth.signpost.signature.AuthorizationHeaderSigningStrategy;
import oauth.signpost.signature.HmacSha1MessageSigner;
import oauth.signpost.signature.OAuthMessageSigner;
import oauth.signpost.signature.SigningStrategy;

class LinkedInOAuthServiceImpl
implements LinkedInOAuthService {
    private final LinkedInApiConsumer apiConsumer;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private static final String OAUTH_VERSION_1_0_a = "1.0a";

    LinkedInOAuthServiceImpl(LinkedInApiConsumer apiConsumer) {
        this.apiConsumer = apiConsumer;
    }

    @Override
    public void setRequestHeaders(Map<String, String> requestHeaders) {
        if (requestHeaders == null) {
            throw new IllegalArgumentException("request headers cannot be null.");
        }
        this.requestHeaders = requestHeaders;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public void addRequestHeader(String headerName, String headerValue) {
        this.requestHeaders.put(headerName, headerValue);
    }

    @Override
    public void removeRequestHeader(String headerName) {
        this.requestHeaders.remove(headerName);
    }

    @Override
    public void addLocale(Locale locale) {
    }

    @Override
    public LinkedInAccessToken getOAuthAccessToken(LinkedInRequestToken requestToken, String oauthVerifier) {
        if (requestToken == null) {
            throw new IllegalArgumentException("request token cannot be null.");
        }
        try {
            OAuthConsumer consumer = this.getOAuthConsumer();
            OAuthProvider provider = this.getOAuthProvider();
            consumer.setTokenWithSecret(requestToken.getToken(), requestToken.getTokenSecret());
            provider.retrieveAccessToken(consumer, oauthVerifier);
            LinkedInAccessToken accessToken = new LinkedInAccessToken(consumer.getToken(), consumer.getTokenSecret());
            SortedSet responseParameters = provider.getResponseParameters().get((Object)ApplicationConstants.EXPIRATION_PARAMETER_NAME);
            this.setTokenExpirationTime(accessToken, responseParameters);
            return accessToken;
        }
        catch (Exception e) {
            throw new LinkedInOAuthServiceException(e);
        }
    }

    @Override
    public LinkedInRequestToken getOAuthRequestToken() {
        try {
            OAuthConsumer consumer = this.getOAuthConsumer();
            OAuthProvider provider = this.getOAuthProvider();
            String authorizationUrl = provider.retrieveRequestToken(consumer, "oob");
            LinkedInRequestToken requestToken = new LinkedInRequestToken(consumer.getToken(), consumer.getTokenSecret());
            requestToken.setAuthorizationUrl(authorizationUrl);
            SortedSet responseParameters = provider.getResponseParameters().get((Object)ApplicationConstants.EXPIRATION_PARAMETER_NAME);
            this.setTokenExpirationTime(requestToken, responseParameters);
            return requestToken;
        }
        catch (Exception e) {
            throw new LinkedInOAuthServiceException(e);
        }
    }

    @Override
    public LinkedInRequestToken getOAuthRequestToken(String callBackUrl) {
        try {
            OAuthConsumer consumer = this.getOAuthConsumer();
            OAuthProvider provider = this.getOAuthProvider();
            String authorizationUrl = provider.retrieveRequestToken(consumer, callBackUrl);
            LinkedInRequestToken requestToken = new LinkedInRequestToken(consumer.getToken(), consumer.getTokenSecret());
            requestToken.setAuthorizationUrl(authorizationUrl);
            return requestToken;
        }
        catch (Exception e) {
            throw new LinkedInOAuthServiceException(e);
        }
    }

    @Override
    public void signRequestWithToken(HttpURLConnection request, LinkedInAccessToken accessToken) {
        if (accessToken == null) {
            throw new IllegalArgumentException("access token cannot be null.");
        }
        try {
            OAuthConsumer consumer = this.getOAuthConsumer();
            consumer.setTokenWithSecret(accessToken.getToken(), accessToken.getTokenSecret());
            consumer.sign((Object)request);
        }
        catch (Exception e) {
            throw new LinkedInOAuthServiceException(e);
        }
    }

    @Override
    public void invalidateAccessToken(LinkedInAccessToken accessToken) {
        if (accessToken == null) {
            throw new IllegalArgumentException("access token cannot be null.");
        }
        try {
            URL url = new URL(LinkedInApiUrls.LINKED_IN_OAUTH_INVALIDATE_TOKEN_URL);
            HttpURLConnection request = (HttpURLConnection)url.openConnection();
            OAuthConsumer consumer = this.getOAuthConsumer();
            consumer.setTokenWithSecret(accessToken.getToken(), accessToken.getTokenSecret());
            consumer.sign((Object)request);
            request.connect();
            if (request.getResponseCode() != 200) {
                throw new LinkedInOAuthServiceException(LinkedInOAuthServiceImpl.convertStreamToString(request.getErrorStream()));
            }
        }
        catch (Exception e) {
            throw new LinkedInOAuthServiceException(e);
        }
    }

    protected OAuthProvider getOAuthProvider() {
        DefaultOAuthProvider provider = new DefaultOAuthProvider(LinkedInApiUrls.LINKED_IN_OAUTH_REQUEST_TOKEN_URL, LinkedInApiUrls.LINKED_IN_OAUTH_ACCESS_TOKEN_URL, LinkedInApiUrls.LINKED_IN_OAUTH_AUTHORIZE_URL);
        provider.setOAuth10a(OAUTH_VERSION_1_0_a.equals(ApplicationConstants.OAUTH_VERSION));
        for (String headerName : this.requestHeaders.keySet()) {
            provider.setRequestHeader(headerName, this.requestHeaders.get(headerName));
        }
        return provider;
    }

    protected OAuthConsumer getOAuthConsumer() {
        DefaultOAuthConsumer consumer = new DefaultOAuthConsumer(this.apiConsumer.getConsumerKey(), this.apiConsumer.getConsumerSecret());
        consumer.setMessageSigner((OAuthMessageSigner)new HmacSha1MessageSigner());
        consumer.setSigningStrategy((SigningStrategy)new AuthorizationHeaderSigningStrategy());
        return consumer;
    }

    protected void setTokenExpirationTime(LinkedInOAuthToken token, SortedSet<String> responseParameters) {
        if (responseParameters != null && !responseParameters.isEmpty()) {
            Calendar calendar = Calendar.getInstance();
            int secondsToLive = Integer.valueOf(responseParameters.first());
            calendar.add(13, secondsToLive);
            token.setExpirationTime(calendar.getTime());
        }
    }

    protected static String convertStreamToString(InputStream is) {
        StringBuilder sb;
        block12: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            sb = new StringBuilder();
            String line = null;
            try {
                try {
                    while ((line = reader.readLine()) != null) {
                        sb.append(String.valueOf(line) + "\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }
}

