/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.client.enumeration;

import com.google.code.linkedinapi.client.enumeration.FieldEnum;
import com.google.code.linkedinapi.client.enumeration.SearchEnum;
import com.google.code.linkedinapi.client.enumeration.SearchScope;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum SearchSortOrder implements FieldEnum,
SearchEnum
{
    CONNECTIONS("connections", (Set<SearchScope>)EnumSet.of(SearchScope.PEOPLE)),
    RECOMMENDERS("recommenders", (Set<SearchScope>)EnumSet.of(SearchScope.PEOPLE)),
    DISTANCE("distance", (Set<SearchScope>)EnumSet.of(SearchScope.PEOPLE)),
    RELATIONSHIP("relationship", (Set<SearchScope>)EnumSet.of(SearchScope.COMPANIES)),
    FOLLOWERS("followers", (Set<SearchScope>)EnumSet.of(SearchScope.COMPANIES)),
    COMPANY_SIZE("company-size", (Set<SearchScope>)EnumSet.of(SearchScope.COMPANIES)),
    RELEVANCE("relevance", (Set<SearchScope>)EnumSet.of(SearchScope.PEOPLE, SearchScope.COMPANIES));

    private static final Map<String, SearchSortOrder> stringToEnum;
    private final String fieldName;
    private final Set<SearchScope> scopes;

    static {
        stringToEnum = new HashMap<String, SearchSortOrder>();
        SearchSortOrder[] searchSortOrderArray = SearchSortOrder.values();
        int n = searchSortOrderArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchSortOrder op = searchSortOrderArray[n2];
            stringToEnum.put(op.fieldName(), op);
            ++n2;
        }
    }

    private SearchSortOrder(String name, Set<SearchScope> scopes) {
        this.fieldName = name;
        this.scopes = scopes;
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    public String toString() {
        return this.fieldName();
    }

    @Override
    public boolean hasScope(SearchScope scope) {
        return this.scopes.contains(scope);
    }

    public static SearchSortOrder fromString(String symbol) {
        return stringToEnum.get(symbol);
    }
}

