package services
{
  import flash.filesystem.File;
  import flash.filesystem.FileMode;
  import flash.filesystem.FileStream;
  import flash.utils.IDataInput;
  import mx.collections.ArrayCollection;
  import models.MusicEntry;

  public class LocalMusicService implements MusicService {
    private static const DEFAULT_DIR:File = 
        File.userDirectory.resolvePath("Music");
    
      /**
       * Znajduje wszystkie pliki w katalogu wskazanym za pomoc zmiennej rootPath
       * i dodaje je do kolekcji, jeli s katalogiem lub plikiem MP3.
       * 
       * @return Kolekcja obiektw MusicEntry.
       */
 
    public function getMusicEntries(rootPath:String=null):ArrayCollection {
      var rootDir:File = rootPath ? new File(rootPath) : DEFAULT_DIR;
      var songList:ArrayCollection = new ArrayCollection();
      
      if (rootDir.isDirectory) {
        var dirListing:Array = rootDir.getDirectoryListing();
        
        for (var i:int = 0; i < dirListing.length; i++) {
          var file:File = dirListing[i];
          
          if (!shouldBeListed(file))
            continue;
          
          songList.addItem(createMusicEntryForFile(file));
        }
      }
      
      return songList;
    }

    /**
    * @return Odpowiedni typ MusicEntry dla danego pliku.
    */ 
    private function createMusicEntryForFile(file:File):MusicEntry {
      var name:String = stripFileExtension(file.name);
      var url:String = "file://" + file.nativePath; 
      var stream:Function = null;
      
      if (!file.isDirectory) {
        stream = function():IDataInput {
          var stream:FileStream = new FileStream();
          stream.openAsync(file, FileMode.READ);
          return stream;
        }
      }

      return new MusicEntry(name, url, stream);
    }
    
    /**
     * @return True jeli zmienna file jest katalogiem lub plikiem MP3.
     */ 
    private function shouldBeListed(file:File):Boolean {
      return file.isDirectory || endsWith(file.name, ".mp3");
    }
    
    /**
     * @return True jeli koniec parametru str odpowiada (pomijajc wielko liter)
     *         parametrowi end.
     */  
    private function endsWith(str:String, end:String):Boolean {
      str = str.toLowerCase();
      end = end.toLowerCase();
      return str.lastIndexOf(end) == str.length - end.length;    
    }
    
    /**
     * @return Cig znakw odpowiadajcy parametrowi fileName z usunitymi znakami po ostatniej
     * kropce (cznie z ni).
     */  
    private function stripFileExtension(fileName:String):String {
      var extIndex:int = fileName.lastIndexOf(".");
      if (extIndex == -1)
        return fileName;
      
      return fileName.substr(0, extIndex);
    }
  }
}