import flash.events.Event;
import flash.filters.ColorMatrixFilter;
import flash.filters.ConvolutionFilter;
import flash.filters.DisplacementMapFilter;
import flash.media.CameraRoll;

private static const CAM_NOT_SUPPORTED:String = "flash.media.Camera " + 
  "nie jest obsugiwana na tym urzdzeniu.";
private static const ROLL_NOT_SUPPORTED:String = "flash.media." + 
  "CameraRoll nie jest obsugiwana na tym urzdzeniu.";

private var camera:Camera;
private var roll:CameraRoll;

private var nightVisionFilter:ColorMatrixFilter;
private var ultraSharpFilter:ConvolutionFilter;
private var displacementFilter:DisplacementMapFilter;

[Embed(source="funny_face.png")]
private var funnyFaceImage:Class;

[Embed(source="ripples.png")]
private var rippleImage:Class;

private var rippleBmp:Bitmap = new rippleImage() as Bitmap;
private var funnyFaceBmp:Bitmap = new funnyFaceImage() as Bitmap;

private var timer:Timer;
private var fpsString:String;

private function onCreationComplete():void {
  var screenWidth:Number = Screen.mainScreen.bounds.width;
  var screenHeight:Number = Screen.mainScreen.bounds.height;
  
  initFilters(screenWidth, screenHeight);
  setCaptureMode(true);
  
  if (Camera.isSupported) {
    camera = Camera.getCamera();
    camera.setMode(screenWidth, screenHeight, 25);
    camera.setQuality(0, 0);
  
    roll = new CameraRoll();
    roll.addEventListener(Event.COMPLETE, onComplete);
 
    var video:Video = new Video(screenWidth, screenHeight);
    video.attachCamera(camera);
    
    videoContainer.addChild(video);
    videoContainer.addEventListener(MouseEvent.CLICK, onTouch);
    
    fpsString = " FPS ("+camera.width+"x"+camera.height+")";
    
    timer = new Timer(2000);
    timer.addEventListener(TimerEvent.TIMER, updateFPS);
    timer.start();
  } else {
    showNotSupportedMsg(CAM_NOT_SUPPORTED);
    captureButton.visible = false;
  }
}

private function initFilters(screenWidth:Number, screenHeight:Number): void {
  var colorMat: Array = [.5,  0,  0,  0,  0, 
                          0, 10,  0,  0,  0, 
                          0,  0, .5,  0,  0, 
                          0,  0,  0,  1,  0];
  nightVisionFilter = new ColorMatrixFilter(colorMat);
  
  var sharpMat:Array = [ 0, -5,  0, -5, 20, -5, 0, -5,  0]; 
  ultraSharpFilter = new ConvolutionFilter(3, 3, sharpMat); 
  
  var bmpData:BitmapData = new BitmapData(screenWidth, screenHeight, false);
  var pt:Point = new Point(0, 0);
  
  displacementFilter = new DisplacementMapFilter(bmpData, pt, 
    BitmapDataChannel.RED, BitmapDataChannel.RED, 40, 40);
}

private function updateFPS(event:TimerEvent):void {
  messageLabel.text = fpsFormatter.format(camera.currentFPS) + fpsString;
}

private function onTouch(event: MouseEvent):void {
  if (messageLabel.visible) {
    timer.stop();
    messageLabel.visible = false; 
  } else {
    timer.start();
    messageLabel.visible = true;
  }
}

private function onFilterChange(event:Event):void {
   var btn: Button = event.target as Button;
   switch (btn.id) {
      case "noFilterBtn":
         videoContainer.filters = [];
         break;

      case "nightVisionBtn":
         videoContainer.filters = [nightVisionFilter];
         break;

      case "sharpBtn":
         videoContainer.filters = [ultraSharpFilter];
         break;

      case "rippleBtn":
      showDisplacementFilter(true);
      break;

   case "funnyFaceBtn":
      showDisplacementFilter(false);
      break;
   }

}

private function showDisplacementFilter(ripples:Boolean):void {
  var bmp:Bitmap = ripples ? rippleBmp : funnyFaceBmp;
  
  var mat:Matrix = new Matrix();
  mat.scale(width/bmp.width, height/bmp.height);
  
  displacementFilter.mapBitmap.draw(bmp, mat);
  
  videoContainer.filters = [displacementFilter];
}

private function onCaptureImage():void {
  var bmp:BitmapData = new BitmapData(width, height, false, 0xffffff);
  bmp.draw(videoContainer);
  
  bitmapContainer.addChild(new Bitmap(bmp));
  setCaptureMode(false);
}

private function onSaveImage():void {
  if (CameraRoll.supportsAddBitmapData) {
    busy.visible = true;
    var bmp:Bitmap = bitmapContainer.getChildAt(0) as Bitmap;
    roll.addBitmapData(bmp.bitmapData);
  } else {
    showNotSupportedMsg(ROLL_NOT_SUPPORTED);
    saveButton.visible = false;
  }
}

private function onComplete(event:Event):void {
  busy.visible = false;
  bitmapContainer.removeChildAt(0)
  setCaptureMode(true);
}

private function onDiscardImage():void {
  bitmapContainer.removeChildAt(0);
  setCaptureMode(true);
}

private function setCaptureMode(capture:Boolean):void {
  videoContainer.visible = capture;
  bitmapContainer.visible = !capture;
  
  captureButton.visible = capture;
  saveButton.visible = !capture;
  discardButton.visible = !capture;        
}

private function showNotSupportedMsg(msg:String):void {
  messageLabel.text = msg;
  messageLabel.visible = true;
}
