import flash.data.SQLStatement;
import flash.errors.SQLError;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.SecurityErrorEvent;
import flash.events.SQLErrorEvent;
import flash.events.SQLEvent;
import flash.events.TimerEvent;
import flash.filesystem.File;
import flash.net.URLLoader;
import flash.net.URLRequest;
import flash.net.URLRequestHeader;
import flash.net.URLRequestMethod;
import flash.net.URLVariables;
import flash.utils.Timer;

import mx.collections.ArrayCollection;
import mx.utils.Base64Encoder;

//import mx.controls.Alert;
import mx.utils.ObjectUtil;
import org.osmf.events.TimeEvent;

private var loader:URLLoader;

//URL Montastic 
private static const montasticURL:String = 
         "https://www.montastic.com/checkpoints/show";

// sqlconn przechowuje poczenie z baz danych
public var sqlconn:SQLConnection = new SQLConnection();

// sqlstmt jest obiektem SQLStatement przechowujcym zapytania SQL
public var sqlstmt:SQLStatement = new SQLStatement();

// obiekt ArrayCollection typu Bindable i rdo danych dla kontrolki DataGrid
[Bindable]
public var dp:ArrayCollection = new ArrayCollection();
[Bindable]
public var url:String = "http://www.yahoo.com";
[Bindable]
public var status:String = "UP";
[Bindable]
public var allStatuses:String = "1:UP#2:UP#3:UP";

private var urlList:Array = new Array();
private var statusList:Array = new Array();


// Currently we use a hard-coded XML string for illustration purposes, 
// and you can invoke the Montastic API for programmatically retrieving 
// XML-based information about registered websites when the syntax for 
// such an invocation is publicly available
public var checkpointsXMLList:XML = 
  <checkpoints>
  <checkpoint>
   <check-interval-id type="integer">360</check-interval-id>
   <grep-presence type="boolean">true</grep-presence>
   <grep-this nil="true"></grep-this>
   <id type="integer">23-5-0</id>
   <is-monitoring-enabled type="boolean">true</is-monitoring-enabled>
   <name></name>
   <status type="integer">-1</status>
   <status-changed-on type="datetime">2011-01-18T05:2-:25-06:00</status-changed-on>
   <url>http://www.myfirstsite.com</url>
  </checkpoint>
  <checkpoint>
   <check-interval-id type="integer">360</check-interval-id>
   <grep-presence type="boolean">true</grep-presence>
   <grep-this nil="true"></grep-this>
   <id type="integer">23-5-0</id>
   <is-monitoring-enabled type="boolean">true</is-monitoring-enabled>
   <name></name>
   <status type="integer">-1</status>
   <status-changed-on type="datetime">2011-01-18T05:2-:25-06:00</status-changed-on>
   <url>http://www.mysecondsite.com</url>
  </checkpoint>
  </checkpoints>;

// wywoywane po zaadowaniu aplikacji
private function start():void {
  // ustaw montastic.db jako plik naszej bazy danych (tworzony po otwarciu)
  var db:File = File.applicationStorageDirectory.resolvePath("montastic.db");
  
  // otwrz baz danych w trybie asynchronicznym
  sqlconn.openAsync(db);

  // detektory zdarze dla obsugi bdw i zdarzenia RESULT s
  // wywoywane przy pobieraniu danych z bazy
  sqlconn.addEventListener(SQLEvent.OPEN, db_opened);
  sqlconn.addEventListener(SQLErrorEvent.ERROR, error);
  sqlstmt.addEventListener(SQLErrorEvent.ERROR, error);
  sqlstmt.addEventListener(SQLEvent.RESULT, result);
}

private function db_opened(e:SQLEvent):void {
  // wska poczenie dla zapytania SQL
  sqlstmt.sqlConnection = sqlconn;
  
  // Tabela montastic_table zawiera trzy kolumny:
  // 1) id (autoinkrementowana liczba cakowita)
  // 2) url (url kadej witryny)
  // 3) status (stan kadej witryny)
  sqlstmt.text = "CREATE TABLE IF NOT EXISTS montastic_table ( id INTEGER PRIMARY KEY AUTOINCREMENT, url TEXT, status TEXT);";
  
  // wykonaj sqlstmt w celu aktualizacji bazy
  sqlstmt.execute();

  // odwie kontolk DataGrid, aby wywietli wszystkie wiersze danych
  refreshDataGrid();
}


// funkcja dodajca nowe wiersze to tabeli montastic_table
// uyj bloku begin/commit do dodawania kilku wierszy
private function addWebsiteInfo():void {
  allStatuses = "";
  sqlconn.begin();

  for (var i:uint = 0; i < urlList.length; i++) {
     var stmt:SQLStatement = new SQLStatement();
     stmt.sqlConnection = sqlconn;

     stmt.text = "INSERT INTO montastic_table (url, status) VALUES(:url, :status);";
     stmt.parameters[":url"] = urlList[i];
     stmt.parameters[":status"] = statusList[i];

     stmt.execute();
  }
   
  // wstaw wiersze do tabeli w bazie danych
  sqlconn.commit();

  refreshDataGrid();
}

// odwie dane Montastic w DataGrid
private function refreshDataGrid(e:TimerEvent = null):void {
  // obiekt timer zatrzymuje wykonanie i wznawia je
  var timer:Timer = new Timer(100,1);
  timer.addEventListener(TimerEvent.TIMER, refreshDataGrid);

  if ( !sqlstmt.executing ) {
    sqlstmt.text = "SELECT * FROM montastic_table"
    sqlstmt.execute();
  } else {
    timer.start();
  }
}

// wywoywana, kiedy otrzymujemy dane z zapytania sql,
// ta metoda bdzie take wywoywana dla zapyta sql wstawiajcych elementy
// oraz do utworzenia tabeli, ale w takim przypadku sqlstmt.getResult().data bdzie mie warto null
private function result(e:SQLEvent):void {
  var data:Array = sqlstmt.getResult().data;

  // wypenij kontrolk DataGrid najwieszymi danymi
  dp = new ArrayCollection(data);
}

// usu wszystkie wiersze z tabeli
private function removeAll():void {
  sqlstmt.text = "DELETE FROM montastic_table"; 
  sqlstmt.execute();

  refreshDataGrid();
}


// funkcje dla Montastic
public function invokeMontastic():void {
   var loader:URLLoader = new URLLoader();
   loader.addEventListener(Event.COMPLETE, completeHandler);
   loader.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
   
   var request:URLRequest = new URLRequest( montasticURL );
   request.method = URLRequestMethod.GET;

   var encoder:Base64Encoder = new Base64Encoder();
   encoder.encode("yourname@yahoo.com:tutaj-wstaw-swoje-haso");
   request.requestHeaders.push(new URLRequestHeader("Authorization",
                                                    "Basic " + encoder.toString()));
   request.requestHeaders.push(new URLRequestHeader("pragma", "no-cache"));
   request.requestHeaders.push(new URLRequestHeader("Accept",
                                                    "application/xml"));
   request.requestHeaders.push(new URLRequestHeader("Content-Type",
                                                    "application/xml"));
   loader.load(request);
}

private function completeHandler(event:Event):void {
   var loader:URLLoader = URLLoader(event.target);
   checkpointsXMLList = new XML(loader.data);

   urlList = new Array();
   statusList = new Array();
   
   for each (var checkpoint:XML in checkpointsXMLList.checkpoint) {
      statusList.push(checkpoint.status.toString());
      urlList.push(checkpoint.url.toString());
   }

   allStatuses = "1="+statusList[0]+"#2="+statusList[1];
   
addWebsiteInfo();
}


private function getStatusOfRegisteredWebsites():void {
  var loader:URLLoader = new URLLoader();
  configureListeners(loader);
  
  var header:URLRequestHeader = new URLRequestHeader("pragma", "no-cache");
  var header2:URLRequestHeader = new URLRequestHeader("Accept",
                                                      "application/xml");
  
  var header3:URLRequestHeader = new URLRequestHeader("Content-Type",
                                                      "application/xml");
  
  var request:URLRequest = new URLRequest( montasticURL );
  
  request.data = new URLVariables("key=tu-wstaw-klucz");
  
  request.method = URLRequestMethod.GET;
//request.method = URLRequestMethod.POST;

  request.requestHeaders.push(header);
  request.requestHeaders.push(header2);
  request.requestHeaders.push(header3);
  
  try {
    loader.load(request);
  } catch (error:Error) {
    trace("Nie udao si zaadowa danego dokumentu.");
  }   
}   

private function configureListeners(dispatcher:IEventDispatcher):void {
  dispatcher.addEventListener(Event.COMPLETE, completeHandler);
  dispatcher.addEventListener(Event.OPEN, openHandler);
  dispatcher.addEventListener(ProgressEvent.PROGRESS, progressHandler);

  dispatcher.addEventListener(SecurityErrorEvent.SECURITY_ERROR, 
    securityErrorHandler);

  dispatcher.addEventListener(HTTPStatusEvent.HTTP_STATUS,
    httpStatusHandler);

  dispatcher.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
}

private function completeHandler(event:Event):void {
  var loader:URLLoader = URLLoader(event.target);
  checkpointsXMLList = loader.data;
}

private function openHandler(event:Event):void {
//trace("openHandler: " + event);
}

private function progressHandler(event:ProgressEvent):void {
//trace("progressHandler zaadowano:" + event.bytesLoaded +
//  " cznie: " + event.bytesTotal);
}

private function securityErrorHandler(event:SecurityErrorEvent):void {
//trace("securityErrorHandler: " + event);
}

private function httpStatusHandler(event:HTTPStatusEvent):void {
//trace("httpStatusHandler: " + event);
}

private function ioErrorHandler(event:IOErrorEvent):void {
//trace("ioErrorHandler: " + event);
}

private function writeOutput(data:String):void
{
 //outputField.text += data + "\n";
}

private function onIOError(e:IOErrorEvent):void
{
   writeOutput("IOError : " + e.text);
}

private function onSecurityError(e:SecurityErrorEvent):void
{
   writeOutput("SecurityError : " + e.text);
}

// funkcja obsugi bdu 
private function error(e:SQLErrorEvent):void {
//        Alert.show(e.toString());
}
