package
{
  import flash.display.Bitmap;
  import flash.display.GradientType;
  import flash.display.Graphics;
  import flash.display.SpreadMethod;
  import flash.display.Sprite;
  import flash.events.MouseEvent;
  import flash.geom.Matrix;
  import flash.text.TextFormat;
  import qnx.ui.buttons.LabelButton;
  import qnx.ui.text.Label;
  
  [SWF(width="1024", height="600", frameRate="30")]
  public class PlayBookHelloWorld extends Sprite
  {
    [Embed(source="splash.png")]
    private var imageClass:Class;
    
    public function PlayBookHelloWorld()
    {
      var bitmap:Bitmap = new imageClass();
      bitmap.x = 10;
      bitmap.y = 10;
      
      var goodByeButton:LabelButton = new LabelButton();
      goodByeButton.label = "Do zobaczenia";
      goodByeButton.x = stage.stageWidth - goodByeButton.width;
      goodByeButton.y = stage.stageHeight - goodByeButton.height;
      goodByeButton.addEventListener(MouseEvent.CLICK, onClick);
      
      var myFormat:TextFormat = new TextFormat();
      myFormat.color = 0xf0f0f0;
      myFormat.size = 48;
      myFormat.italic = true;
      
      var label:Label = new Label();
      label.text = "Witaj, Pro Android Flash!";
      label.x = bitmap.width + 20;
      label.y = 10;
      label.width = stage.stageWidth - bitmap.width - 10;
      label.height = 100;
      label.format = myFormat;
      
      addChild(createBackground());
      addChild(bitmap);
      addChild(goodByeButton);
      addChild(label);
      
      stage.nativeWindow.visible = true;
    }
    
    private function onClick(event:MouseEvent):void{
      stage.nativeWindow.close();
    }
    
    private function createBackground():Sprite {
      var type:String = GradientType.LINEAR;
      var colors:Array = [ 0x808080, 0x404040 ];
      var alphas:Array = [ 1, 1 ];
      var ratios:Array = [ 0, 255 ];
      var spread:String = SpreadMethod.PAD;
      
      var matrix:Matrix = new Matrix();
      matrix.createGradientBox( 100, 100, (90 * Math.PI/180), 0, 0 );
      
      var sprite:Sprite = new Sprite();
      var g:Graphics = sprite.graphics;
      g.beginGradientFill( type, colors, alphas, ratios, matrix, spread );
      g.drawRect( 0, 0, 1024, 600 );
      
      return sprite;      
    }
  }
}