package views
{
  import flash.display.DisplayObject;
  import flash.events.MouseEvent;
  import flash.utils.getTimer;
  
  import spark.components.Group;
  import spark.components.supportClasses.SkinnableComponent;

  [SkinState("pause")]
  public class ProgressButton extends SkinnableComponent
  {
    [SkinPart(required="true")]
    public var playIcon:DisplayObject;
    
    [SkinPart(required="true")]
    public var pauseIcon:DisplayObject;
    
    [SkinPart(required="true")]
    public var background:Group;

    [Bindable]
    public var percentComplete:Number = 0;
    
    private var mouseDownTime:Number;
    private var isMouseDown:Boolean;
    
    public function ProgressButton() {
       // Upewnij si, e mysz nie wchodzi w interakcje z adnymi czciami skrki
      mouseChildren = false;
      
      addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
      addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
      addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
      addEventListener(MouseEvent.CLICK, onMouseClick);
    }
    
    /**
     * Jeli znajduje si w stanie "play", zatrzymuje pasek  postpu i zmienia stan kontrolki z "play" na "pause".
     */
    public function stop():void {
      if (isPlaying()) {
        togglePlayPause();
      }
    }
    
    /**
     * @return True, jeli kontrolka jest w stanie "play".
     */
    public function isPlaying():Boolean {
      return pauseIcon && pauseIcon.visible;
    }
    
    override protected function getCurrentSkinState():String {
      if (isPlaying()) {
        return "play";
      } else {
        return "pause";
      }
    }
    
    override protected function partAdded(partName:String, instance:Object):void {
      super.partAdded(partName, instance);
      
      if (instance == pauseIcon) {
        pauseIcon.visible = false;
      }
    }
    
    override protected function partRemoved(partName:String, instance:Object):void {
      super.partRemoved(partName, instance);
    }
    
    private function onMouseDown(event:MouseEvent):void {
      mouseDownTime = getTimer();
      isMouseDown = true;
    }
    
    private function onMouseMove(event:MouseEvent):void {
      if (isMouseDown && getTimer() - mouseDownTime > 250) {
        percentComplete = event.localX / width * 100;
      }
    }
    
    private function onMouseUp(event:MouseEvent):void {
      isMouseDown = false;
    }
    
    private function onMouseClick(event:MouseEvent):void {
      if (getTimer() - mouseDownTime < 250) {
        togglePlayPause();
      } else {
        event.stopImmediatePropagation();
      }
    }
    
    private function togglePlayPause():void {
      if (playIcon.visible) {
        playIcon.visible = false;
        pauseIcon.visible = true;
      } else {
        playIcon.visible = true;
        pauseIcon.visible = false;
      }
    }
    
  }
}