import flash.media.CameraUI;

import org.osmf.elements.VideoElement;
import org.osmf.events.DisplayObjectEvent;
import org.osmf.events.MediaElementEvent;
import org.osmf.events.TimeEvent;
import org.osmf.media.MediaPlayer;
import org.osmf.media.URLResource;
import org.osmf.net.NetLoader;

private var cameraUI:CameraUI;
private var player:MediaPlayer;
private var duration:String;

private function onInitialize():void {
  if (CameraUI.isSupported) {
    cameraUI = new CameraUI();
    cameraUI.addEventListener(MediaEvent.COMPLETE, onCaptureComplete);
  }
  
  captureButton.visible = CameraUI.isSupported;
  
  player = new MediaPlayer();
  
  player.addEventListener(DisplayObjectEvent.MEDIA_SIZE_CHANGE, onSize);
  player.addEventListener(TimeEvent.CURRENT_TIME_CHANGE, onTimeChange);
  player.addEventListener(TimeEvent.DURATION_CHANGE, onDurationChange);
  player.addEventListener(TimeEvent.COMPLETE, onVideoComplete);
  
  player.currentTimeUpdateInterval = 1000;
  player.autoPlay = false;
}

private function onViewDeactivate():void {
  if (player)
    player.stop();
}

private function onPlayPause():void {
  if (player.playing) {
    player.pause();
  } else {
    player.play();
  }
}

private function onDurationChange(event:TimeEvent):void {
  duration = formatSeconds(player.duration);
}

private function onTimeChange(event:TimeEvent):void {
  updateTimeDisplay(formatSeconds(player.currentTime));
}

private function onVideoComplete(event:TimeEvent):void{
  player.seek(0);
  playBtn.selected = false;
}

private function onSize(event:DisplayObjectEvent):void {
  if (player.displayObject == null)
    return;
  
  var scaleX:int = Math.floor(width / event.newWidth);
  var scaleY:int = Math.floor(height / event.newHeight);
  var scale:Number = Math.min(scaleX, scaleY);
  
  player.displayObject.width = event.newWidth * scale;
  player.displayObject.height = event.newHeight * scale;
  
  player.displayObject.x = (width - player.displayObject.width) / 2;
  player.displayObject.y = (height - player.displayObject.height) / 2;
}

private function onCaptureImage():void {
  cameraUI.launch(MediaType.VIDEO);
}

private function onCaptureComplete(event:MediaEvent):void {
  player.media = new VideoElement(new URLResource(event.data.file.url));
  player.play();

  playBtn.selected = true;
  playBtn.visible = true;
  
  if (videoContainer.numChildren > 0)
    videoContainer.removeChildAt(0);
  
  videoContainer.addChild(player.displayObject);
}

private function updateTimeDisplay(time:String):void {
  if (duration) 
    time += " / "+ duration;
  
  timeDisplay.text = time;
}

private function formatSeconds(time:Number):String {
  var minutes:int = time / 60;
  var seconds:int = int(time) % 60;
  
  return String(minutes+":"+(seconds<10 ? "0" : "")+seconds);
}
