import flash.events.Event;
import flash.events.SampleDataEvent;
import flash.events.StageOrientationEvent;
import flash.events.TouchEvent;
import flash.media.Microphone;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.ui.Multitouch;
import flash.ui.MultitouchInputMode;
import flash.utils.ByteArray;

import mx.graphics.SolidColor;
import mx.graphics.SolidColorStroke;

import spark.primitives.Ellipse;
import spark.primitives.Path;
import spark.primitives.Rect;

private static const DECAY:uint = 5;
private static const SOUND_RATE:uint = 44;
private static const MICROPHONE_RATE:uint = 22;

private var curves:Path;
private var activityLevel:uint;
private var recordedBytes:ByteArray;

private var sound:Sound;
private var soundChannel:SoundChannel;
private var microphone:Microphone;

[Bindable]
private var freqMultiplier:Number;
private var touchAnchor:Number;
private var isDrag:Boolean;

private function onOrientationChange(event:StageOrientationEvent):void {
  var backgroundRect: Rect = canvas.getElementAt(0) as Rect;
  backgroundRect.width = stage.stageWidth;
  backgroundRect.height = stage.stageHeight;
}

private function onCreationComplete():void {
  messageLabel.maxWidth = width;
  messageLabel.maxHeight = height;
  
  if (Microphone.isSupported) {
    microphone = Microphone.getMicrophone();
    
    microphone.setSilenceLevel(0)
    microphone.gain = 75;
    microphone.rate = MICROPHONE_RATE;
    
    sound = new Sound();
    recordedBytes = new ByteArray();
    
    Multitouch.inputMode = MultitouchInputMode.TOUCH_POINT;
    initGraphics();
    
    showMessage("Mw, sysz Ci...");
  } else {
    showMessage("mikrofon nieobsugiwany");
  }
}

private function initGraphics(): void {
  var r: Rect = new Rect();
  r.fill = new SolidColor(0x000040);
  r.percentHeight = 100;
  r.percentWidth = 100;
  canvas.addElement(r);
  
  curves = new Path();
  curves.fill = new SolidColor(0x80a0d0);
  curves.stroke = new SolidColorStroke(0xa0c0ff, 2);
  canvas.addElement(curves);
  
  addEventListener(Event.ENTER_FRAME, onFrame);
}

private function onFrame(event:Event):void {
  var halfHeight:Number = height / 2;
  var offset:Number = Math.min(height, activityLevel * 10);
  var h1:Number = halfHeight - offset;
  var h2:Number = halfHeight + offset;
  
  var pathString:String = "";
  var curveCount:uint = uint(Math.min(20, Math.max(1, activityLevel)));
  var curveWidth:Number = (width - 1) / curveCount;
  
  for (var i: int = 0; i < curveCount; ++i) {
    var x0: Number = i * curveWidth;
    var x1: Number = x0 + curveWidth;
    
    pathString += pathMove(x0, halfHeight );
    pathString += pathCurve(x0 + curveWidth * .45, h1,
                            x0 + curveWidth * .55, h2, 
                            x1, halfHeight );
  }
  
  curves.data = pathString;
  
  if (activityLevel >= DECAY) {
    activityLevel -= DECAY;
  } else {
    activityLevel = Math.random();
  }
}

private function pathMove(x:Number, y:Number):String {
  return " M "+x+","+y;
}

private function pathCurve(x0: Number,   y0: Number,
                           x1: Number,   y1: Number, 
                           xEnd: Number, yEnd: Number):String {
  return " C "+x0+","+y0+" "+x1+","+y1+" "+xEnd+","+yEnd;
}

private function onMicSample(event:SampleDataEvent):void {
  if (microphone.activityLevel > activityLevel) {
    activityLevel = Math.min(50, microphone.activityLevel);
  }
  
  if (event.data.bytesAvailable) {
    recordedBytes.writeBytes(event.data);
  }
}

// Ta funkcja zostanie wywoana, kiedy obiekt Sound bdzie potrzebowa wicej danych
private function onSoundSample(event:SampleDataEvent):void {
  if (soundChannel) {
    var avgPeak:Number = (soundChannel.leftPeak + soundChannel.rightPeak) / 2;
    activityLevel = avgPeak * 50;
  }
  // Oblicz liczb prbek stereo do zapisania dla kadej prbki z mikrofonu   
  var sample:Number = 0;
  var sampleCount:int = 0;
  var overSample:Number = SOUND_RATE / MICROPHONE_RATE * freqMultiplier;
  
  while (recordedBytes.bytesAvailable && sampleCount < 2048/overSample) {
    sample = recordedBytes.readFloat();
    for (var i:int=0; i<overSample; ++i) {
      // Zapisz dane dwukrotnie, aby skonwertowa mono na stereo
      event.data.writeFloat(sample);
      event.data.writeFloat(sample);
    }
    ++sampleCount;
  }
}

private function onSoundComplete(event:Event):void {
  incrementProgramState();
}

private function onTouchTap(event:TouchEvent):void {
  if (currentState == "playing" && isDrag) {
    return;
  }
  
  incrementProgramState();
}

private function onTouchBegin(event:TouchEvent):void {
  touchAnchor = event.localY;
  isDrag = false;
}

private function onTouchMove(event:TouchEvent):void {
  var delta:Number = event.localY - touchAnchor;
  if (Math.abs(delta) > 75) {
    isDrag = true;
    touchAnchor = event.localY;
    freqMultiplier *= (delta > 0 ? 2 : 0.5);
    freqMultiplier = Math.min(2, Math.max(0.5, freqMultiplier));
  }
}

private function incrementProgramState():void {
  switch (currentState) {
    case "stopped":
      transitionToRecordingState();
      break;
    case "recording":
      transitionToReadyToPlayState();
      break;
    case "readyToPlay":
      transitionToPlayingState();
      break;
    case "playing":
      transitionToStoppedState();
      break;
  }  
}

private function transitionToRecordingState():void {
  recordedBytes.clear();
  microphone.addEventListener(SampleDataEvent.SAMPLE_DATA, onMicSample);
  currentState = "recording";
}

private function transitionToReadyToPlayState():void {
  microphone.removeEventListener(SampleDataEvent.SAMPLE_DATA, onMicSample);
  tapLabel.text = "Odtwrz";
  currentState = "readyToPlay";
}

private function transitionToPlayingState():void {
  freqMultiplier = 1;
  recordedBytes.position = 0;
  
  canvas.addEventListener(TouchEvent.TOUCH_BEGIN, onTouchBegin);
  canvas.addEventListener(TouchEvent.TOUCH_MOVE, onTouchMove);
  
  sound.addEventListener(SampleDataEvent.SAMPLE_DATA, onSoundSample);
  soundChannel = sound.play();
  soundChannel.addEventListener(Event.SOUND_COMPLETE, onSoundComplete);
  
  currentState = "playing";  
}

private function transitionToStoppedState():void {
  canvas.removeEventListener(TouchEvent.TOUCH_BEGIN, onTouchBegin);
  canvas.removeEventListener(TouchEvent.TOUCH_MOVE, onTouchMove);
  
  soundChannel.stop()
  soundChannel.removeEventListener(Event.SOUND_COMPLETE, onSoundComplete);
  sound.removeEventListener(SampleDataEvent.SAMPLE_DATA, onSoundSample);
  
  tapLabel.text = "Nagraj";
  currentState = "stopped";
}

private function showMessage(msg:String):void {
  if (messageLabel.text && messageLabel.height < height) {
    messageLabel.text += "\n" + msg;
  } else {
    messageLabel.text = msg;
  }
}
