import flash.display.Screen;
import flash.filters.ColorMatrixFilter;
import flash.filters.ConvolutionFilter;
import flash.filters.DisplacementMapFilter;

import spark.components.ViewMenuItem;

private var camera:Camera;

private var nightVisionFilter:ColorMatrixFilter;
private var ultraSharpFilter:ConvolutionFilter;
private var displacementFilter:DisplacementMapFilter;

[Embed(source="funny_face.png")]
private var FunnyFaceImage:Class;

[Embed(source="ripples.png")]
private var RippleImage:Class;

private var rippleBmp:Bitmap = new RippleImage() as Bitmap;
private var funnyFaceBmp:Bitmap = new FunnyFaceImage() as Bitmap;

private var timer:Timer;
private var fpsString:String;

private function onCreationComplete():void {
  var screenWidth:Number = Screen.mainScreen.bounds.width;
  var screenHeight:Number = Screen.mainScreen.bounds.height;
  
  initFilters(screenWidth, screenHeight);
  
  if (Camera.isSupported && (camera = Camera.getCamera()) != null) {    
    camera = Camera.getCamera();
    camera.setMode(screenWidth, screenHeight, 15);
    camera.setQuality(0, 0);
    
    var video: Video = new Video(screenWidth, screenHeight);
    video.attachCamera(camera);
    
    videoContainer.addChild(video);
    videoContainer.addEventListener(MouseEvent.CLICK, onTouch);
    
    fpsString = " FPS ("+camera.width+"x"+camera.height+")";
    
    timer = new Timer(2000);
    timer.addEventListener(TimerEvent.TIMER, updateFPS);
    timer.start();
  } else {
    showNotSupportedMsg();
  }
}

private function initFilters(screenWidth:Number, screenHeight:Number):void {
  var colorMat: Array = [ 
    .5,  0,  0,  0,  0, 
     0, 10,  0,  0,  0, 
     0,  0, .5,  0,  0, 
     0,  0,  0,  1,  0
  ];
  nightVisionFilter = new ColorMatrixFilter(colorMat);
  
  var sharpMat:Array = [0, -5,  0, -5, 20, -5, 0, -5,  0]; 
  ultraSharpFilter = new ConvolutionFilter(3, 3, sharpMat); 
  
  var bmpData:BitmapData = new BitmapData(screenWidth, screenHeight, false);
  var pt:Point = new Point(0, 0);
  
  displacementFilter = new DisplacementMapFilter(bmpData, pt, 
    BitmapDataChannel.RED, BitmapDataChannel.RED, 40, 40);
}

private function updateFPS(event: TimerEvent):void {
  messageLabel.text = fpsFormatter.format(camera.currentFPS) + fpsString;
}

private function onTouch(event: MouseEvent):void {
  if (messageLabel.visible) {
    timer.stop();
    messageLabel.visible = false; 
  } else {
    timer.start();
    messageLabel.visible = true;
  }
}

// Ta funkcja obsuguje kliknicia dla wszystkich przyciskw w menu. videoContainer 
// jest obiektem UIComponent wywietlajcym strumie wideo z aparatu
private function onFilterChange(event:Event):void {
   var btn: Button = event.target as Button;
   switch (btn.id) {
      case "noFilterBtn":
         videoContainer.filters = [];
         break;

      case "nightVisionBtn":
         videoContainer.filters = [nightVisionFilter];
         break;

      case "sharpBtn":
         videoContainer.filters = [ultraSharpFilter];
         break;

      case "rippleBtn":
      showDisplacementFilter(true);
      break;

   case "funnyFaceBtn":
      showDisplacementFilter(false);
      break;
   }

   toggleMenu();
}


private function showDisplacementFilter(ripples:Boolean):void {
  var bmp:Bitmap = ripples ? rippleBmp : funnyFaceBmp;
  
  var mat:Matrix = new Matrix();
  mat.scale(width / bmp.width, height / bmp.height);
  
  displacementFilter.mapBitmap.draw(bmp, mat);
  
  videoContainer.filters = [displacementFilter];
}

private function showNotSupportedMsg():void {
  messageLabel.text = "flash.media.Camera is not supported on " +
    "this device.";
}
