// MainActivityFragment.java
// Klasa MainActivityFragment tworzy obiekt CannonView i zarządza nim
package com.deitel.cannongame;

import android.media.AudioManager;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public class MainActivityFragment extends Fragment {
   private CannonView cannonView; // custom view to display the game

   // metoda wywoływana w przypadku konieczności utworzenia widoku w obiekcie Fragment
   @Override
   public View onCreateView(LayoutInflater inflater, ViewGroup container,
      Bundle savedInstanceState) {
      super.onCreateView(inflater, container, savedInstanceState);

      // przygotuj do wyświetlenia rozkład fragment_main.xml
      View view =
         inflater.inflate(R.layout.fragment_main, container, false);

      // uzyskaj odwołanie do CannonView
      cannonView = (CannonView) view.findViewById(R.id.cannonView);
      return view;
   }

   // przygotuj możliwość sterowania głośnością po utworzeniu obiektu Activity
   @Override
   public void onActivityCreated(Bundle savedInstanceState) {
      super.onActivityCreated(savedInstanceState);

      // pozwól na regulację głośności gry za pomocą przycisków głośności
      getActivity().setVolumeControlStream(AudioManager.STREAM_MUSIC);
   }

   // zatrzymaj grę w przypadku wstrzymania MainActivity
   @Override
   public void onPause() {
      super.onPause();
      cannonView.stopGame(); // zatrzymaj działanie gry
   }

   // w przypadku wstrzymania MainActivity MainActivityFragment zwalnia zasoby
   @Override
   public void onDestroy() {
      super.onDestroy();
      cannonView.releaseResources();
   }
}

/*********************************************************************************
 * (C) Copyright 1992-2016 by Deitel & Associates, Inc. and * Pearson Education, *
 * Inc. All Rights Reserved. * * DISCLAIMER: The authors and publisher of this   *
 * book have used their * best efforts in preparing the book. These efforts      *
 * include the * development, research, and testing of the theories and programs *
 * * to determine their effectiveness. The authors and publisher make * no       *
 * warranty of any kind, expressed or implied, with regard to these * programs   *
 * or to the documentation contained in these books. The authors * and publisher *
 * shall not be liable in any event for incidental or * consequential damages in *
 * connection with, or arising out of, the * furnishing, performance, or use of  *
 * these programs.                                                               *
 *********************************************************************************/
