// EraseImageDialogFragment.java
// Pozwala skasować obraz
package com.deitel.doodlz;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.support.v4.app.DialogFragment; //******************************
import android.content.DialogInterface;
import android.os.Bundle;

// klasa okna Kasuj obraz
public class EraseImageDialogFragment extends DialogFragment {
   // utwórz i zwróć AlertDialog
   @Override
   public Dialog onCreateDialog(Bundle bundle) {
      AlertDialog.Builder builder =
         new AlertDialog.Builder(getActivity());

      // określ treść komunikatu okna AlertDialog
      builder.setMessage(R.string.message_erase);

      // dodaj przycisk Kasuj
      builder.setPositiveButton(R.string.button_erase,
         new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
               getDoodleFragment().getDoodleView().clear(); // wyczyść obraz
            }
         }
      );

      // dodaj przycisk Anuluj
      builder.setNegativeButton(android.R.string.cancel, null);
      return builder.create(); // zwróć okno dialogowe
   }

   // uzyskaj odwołanie do MainActivityFragment
   private MainActivityFragment getDoodleFragment() {
      return (MainActivityFragment) getFragmentManager().findFragmentById(
         R.id.doodleFragment);
   }

   // poinformuj MainActivityFragment to tym, że okno jest aktualnie wyświetlane
   @Override
   public void onAttach(Activity activity) {
      super.onAttach(activity);
      MainActivityFragment fragment = getDoodleFragment();

      if (fragment != null)
         fragment.setDialogOnScreen(true);
   }

   // poinformuj MainActivityFragment to tym, że okno nie jest już wyświetlane
   @Override
   public void onDetach() {
      super.onDetach();
      MainActivityFragment fragment = getDoodleFragment();

      if (fragment != null)
         fragment.setDialogOnScreen(false);
   }
}

/**************************************************************************
 * (C) Copyright 1992-2016 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 **************************************************************************/
