// GameElement.java
// Opisuje elementy gry charakteryzujące się prostokątnymi granicami.
package com.deitel.cannongame;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;

public class GameElement {
   protected CannonView view; // widok, w którym znajduje się element GameElement
   protected Paint paint = new Paint(); // obiekt Paint rysujący element GameElement
   protected Rect shape; // prostokątne granice elementu GameElement
   private float velocityY; // prędkość ruchu elementu GameElement w płaszczyźnie pionowej
   private int soundId; // dźwięk powiązany z elementem GameElement

   // publiczny konstruktor
   public GameElement(CannonView view, int color, int soundId, int x,
      int y, int width, int length, float velocityY) {
      this.view = view;
      paint.setColor(color);
      shape = new Rect(x, y, x + width, y + length); // określ granice
      this.soundId = soundId;
      this.velocityY = velocityY;
   }

   // aktualizuj położenie elementu GameElement i sprawdź, czy nie doszło do zderzenia ze ścianą
   public void update(double interval) {
      // aktualizuje położenie w pionie
      shape.offset(0, (int) (velocityY * interval));

      // zmień kierunek ruchu elementu GameElement w przypadku zderzenia się go ze ścianą
      if (shape.top < 0 && velocityY < 0 ||
         shape.bottom > view.getScreenHeight() && velocityY > 0)
         velocityY *= -1; // odwróć prędkość elementu GameElement
   }

   // rysuje element GameElement na danym obiekcie Canvas
   public void draw(Canvas canvas) {
      canvas.drawRect(shape, paint);
   }

   // odtwarza dźwięk właściwy dla danego elementu GameElement
   public void playSound() {
      view.playSound(soundId);
   }
}

/*********************************************************************************
 * (C) Copyright 1992-2016 by Deitel & Associates, Inc. and * Pearson Education, *
 * Inc. All Rights Reserved. * * DISCLAIMER: The authors and publisher of this   *
 * book have used their * best efforts in preparing the book. These efforts      *
 * include the * development, research, and testing of the theories and programs *
 * * to determine their effectiveness. The authors and publisher make * no       *
 * warranty of any kind, expressed or implied, with regard to these * programs   *
 * or to the documentation contained in these books. The authors * and publisher *
 * shall not be liable in any event for incidental or * consequential damages in *
 * connection with, or arising out of, the * furnishing, performance, or use of  *
 * these programs.                                                               *
 *********************************************************************************/
