// Cannon.java
// Metoda przedstawiająca działo i proces wystrzału kuli.
package com.deitel.cannongame;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;

public class Cannon {
   private int baseRadius; // promień podstawy działa
   private int barrelLength; // długość lufy działa
   private Point barrelEnd = new Point(); // końcowy punkt lufy
   private double barrelAngle; // kąt ustawienia lufy
   private Cannonball cannonball; // kula wystrzeliwana z działa
   private Paint paint = new Paint(); // obiekt Paint używany do rysowania działa
   private CannonView view; // obiekt view zawierający działo

   // konstruktor
   public Cannon(CannonView view, int baseRadius, int barrelLength,
      int barrelWidth) {
      this.view = view;
      this.baseRadius = baseRadius;
      this.barrelLength = barrelLength;
      paint.setStrokeWidth(barrelWidth); // określ szerokość lufy
      paint.setColor(Color.BLACK); // działo jest koloru czarnego
      align(Math.PI / 2); // lufa jest zwrócona na wprost, w prawo
   }

   // ustawia lufę działa pod określonym kątem
   public void align(double barrelAngle) {
      this.barrelAngle = barrelAngle;
      barrelEnd.x = (int) (barrelLength * Math.sin(barrelAngle));
      barrelEnd.y = (int) (-barrelLength * Math.cos(barrelAngle)) +
         view.getScreenHeight() / 2;
   }

   // metoda tworząca kulę i wystrzeliwująca ją w kierunku wskazywanym przez lufę
   public void fireCannonball() {
      // oblicz komponent x prędkości ruchu kuli
      int velocityX = (int) (CannonView.CANNONBALL_SPEED_PERCENT *
         view.getScreenWidth() * Math.sin(barrelAngle));

      // oblicz komponent y prędkości ruchu kuli
      int velocityY = (int) (CannonView.CANNONBALL_SPEED_PERCENT *
         view.getScreenWidth() * -Math.cos(barrelAngle));

      // oblicz promień kuli
      int radius = (int) (view.getScreenHeight() *
         CannonView.CANNONBALL_RADIUS_PERCENT);

      // utwórz kulę i umieść ją wewnątrz działa
      cannonball = new Cannonball(view, Color.BLACK,
         CannonView.CANNON_SOUND_ID, -radius,
         view.getScreenHeight() / 2 - radius, radius, velocityX,
         velocityY);

      cannonball.playSound(); // odtwarza dźwięk wystrzału
   }

   // rysuje działo na obiekcie Canvas
   public void draw(Canvas canvas) {
      // rysuje lufę działa
      canvas.drawLine(0, view.getScreenHeight() / 2, barrelEnd.x,
         barrelEnd.y, paint);

      // rysuje podstawę działa
      canvas.drawCircle(0, (int) view.getScreenHeight() / 2,
         (int) baseRadius, paint);
   }

   // zwraca kulę wystrzeloną przez działo
   public Cannonball getCannonball() {
      return cannonball;
   }

   // usuwa kulę z gry
   public void removeCannonball() {
      cannonball = null;
   }
}

/*********************************************************************************
 * (C) Copyright 1992-2016 by Deitel & Associates, Inc. and * Pearson Education, *
 * Inc. All Rights Reserved. * * DISCLAIMER: The authors and publisher of this   *
 * book have used their * best efforts in preparing the book. These efforts      *
 * include the * development, research, and testing of the theories and programs *
 * * to determine their effectiveness. The authors and publisher make * no       *
 * warranty of any kind, expressed or implied, with regard to these * programs   *
 * or to the documentation contained in these books. The authors * and publisher *
 * shall not be liable in any event for incidental or * consequential damages in *
 * connection with, or arising out of, the * furnishing, performance, or use of  *
 * these programs.                                                               *
 *********************************************************************************/
