/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.request;

import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.internal.constants.RequestUpdateResultOutcome;
import java.util.HashMap;
import java.util.Set;

public final class RequestUpdateOutcomes {
    private static final String[] zzaxr = new String[]{"requestId", "outcome"};
    private final int zzWu;
    private final HashMap<String, Integer> zzaxs;

    private RequestUpdateOutcomes(int statusCode, HashMap<String, Integer> outcomeMap) {
        this.zzWu = statusCode;
        this.zzaxs = outcomeMap;
    }

    public int getRequestOutcome(String requestId) {
        zzx.zzb((boolean)this.zzaxs.containsKey(requestId), (Object)("Request " + requestId + " was not part of the update operation!"));
        return this.zzaxs.get(requestId);
    }

    public Set<String> getRequestIds() {
        return this.zzaxs.keySet();
    }

    public static RequestUpdateOutcomes zzY(DataHolder dataHolder) {
        Builder builder = new Builder();
        builder.zzga(dataHolder.getStatusCode());
        int n = dataHolder.getCount();
        for (int i = 0; i < n; ++i) {
            int n2 = dataHolder.zzbo(i);
            builder.zzy(dataHolder.zzd("requestId", i, n2), dataHolder.zzc("outcome", i, n2));
        }
        return builder.zzuP();
    }

    public static final class Builder {
        private HashMap<String, Integer> zzaxs = new HashMap();
        private int zzWu = 0;

        public Builder zzy(String string, int n) {
            if (RequestUpdateResultOutcome.isValid(n)) {
                this.zzaxs.put(string, n);
            }
            return this;
        }

        public Builder zzga(int n) {
            this.zzWu = n;
            return this;
        }

        public RequestUpdateOutcomes zzuP() {
            return new RequestUpdateOutcomes(this.zzWu, this.zzaxs);
        }
    }
}

