/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.signin.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.AuthAccountRequest;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.ResolveAccountRequest;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.signin.internal.AuthAccountResult;
import com.google.android.gms.signin.internal.CheckServerAuthResult;
import com.google.android.gms.signin.internal.zzd;
import com.google.android.gms.signin.internal.zze;
import com.google.android.gms.signin.internal.zzf;
import com.google.android.gms.signin.zzd;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class zzi
extends zzj<zzf>
implements zzd {
    private final boolean zzaOn;
    private final com.google.android.gms.common.internal.zzf zzZH;
    private final com.google.android.gms.signin.zze zzade;
    private Integer zzadf;
    private final ExecutorService zzaOo;

    public zzi(Context context, Looper looper, boolean bl, com.google.android.gms.common.internal.zzf zzf2, com.google.android.gms.signin.zze zze2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, ExecutorService executorService) {
        super(context, looper, 44, zzf2, connectionCallbacks, onConnectionFailedListener);
        this.zzaOn = bl;
        this.zzZH = zzf2;
        this.zzade = zzf2.zzoo();
        this.zzadf = zzf2.zzop();
        this.zzaOo = executorService;
    }

    @Override
    public boolean zzlm() {
        return this.zzaOn;
    }

    @Override
    public void zza(zzt zzt2) {
        zzx.zzb(zzt2, (Object)"Expecting a valid IResolveAccountCallbacks");
        try {
            Account account = this.zzZH.zzog();
            ((zzf)this.zzoA()).zza(new ResolveAccountRequest(account, this.zzadf), zzt2);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when resolveAccount is called");
            try {
                zzt2.zzb(new ResolveAccountResponse(8));
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"IResolveAccountCallbacks#onAccountResolutionComplete should be executed from the same process, unexpected RemoteException.");
            }
        }
    }

    @Override
    public void zza(zzp zzp2, boolean bl) {
        try {
            ((zzf)this.zzoA()).zza(zzp2, this.zzadf, bl);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when saveDefaultAccount is called");
        }
    }

    @Override
    public void zzzn() {
        try {
            ((zzf)this.zzoA()).zzja(this.zzadf);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when clearAccountFromSessionStore is called");
        }
    }

    @Override
    public void zza(zzp zzp2, Set<Scope> set, zze zze2) {
        zzx.zzb(zze2, (Object)"Expecting a valid ISignInCallbacks");
        try {
            ((zzf)this.zzoA()).zza(new AuthAccountRequest(zzp2, set), zze2);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when authAccount is called");
            try {
                zze2.zza(new ConnectionResult(8, null), new AuthAccountResult());
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"ISignInCallbacks#onAuthAccount should be executed from the same process, unexpected RemoteException.");
            }
        }
    }

    @Override
    protected String zzfA() {
        return "com.google.android.gms.signin.service.START";
    }

    @Override
    protected String zzfB() {
        return "com.google.android.gms.signin.internal.ISignInService";
    }

    protected zzf zzdI(IBinder iBinder) {
        return zzf.zza.zzdH(iBinder);
    }

    @Override
    protected Bundle zzli() {
        Bundle bundle = zzi.zza(this.zzade, this.zzZH.zzop(), this.zzaOo);
        String string = this.zzZH.zzol();
        if (!this.getContext().getPackageName().equals(string)) {
            bundle.putString("com.google.android.gms.signin.internal.realClientPackageName", this.zzZH.zzol());
        }
        return bundle;
    }

    @Override
    public void connect() {
        this.zza(new zzj.zzf(this));
    }

    public static Bundle zza(com.google.android.gms.signin.zze zze2, Integer n, ExecutorService executorService) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.signin.internal.offlineAccessRequested", zze2.zzzo());
        bundle.putBoolean("com.google.android.gms.signin.internal.idTokenRequested", zze2.zzzp());
        bundle.putString("com.google.android.gms.signin.internal.serverClientId", zze2.zzlG());
        if (zze2.zzzq() != null) {
            IBinder iBinder = new zza(zze2, executorService).asBinder();
            bundle.putParcelable("com.google.android.gms.signin.internal.signInCallbacks", (Parcelable)new BinderWrapper(iBinder));
        }
        if (n != null) {
            bundle.putInt("com.google.android.gms.common.internal.ClientSettings.sessionId", n.intValue());
        }
        return bundle;
    }

    @Override
    protected /* synthetic */ IInterface zzV(IBinder iBinder) {
        return this.zzdI(iBinder);
    }

    private static class zza
    extends zzd.zza {
        private final com.google.android.gms.signin.zze zzade;
        private final ExecutorService zzaOo;

        public zza(com.google.android.gms.signin.zze zze2, ExecutorService executorService) {
            this.zzade = zze2;
            this.zzaOo = executorService;
        }

        @Override
        public void zza(final String string, final List<Scope> list, final zzf zzf2) throws RemoteException {
            this.zzaOo.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        GoogleApiClient.ServerAuthCodeCallbacks serverAuthCodeCallbacks = zza.this.zzzq();
                        Set<Scope> set = Collections.unmodifiableSet(new HashSet(list));
                        GoogleApiClient.ServerAuthCodeCallbacks.CheckResult checkResult = serverAuthCodeCallbacks.onCheckServerAuthorization(string, set);
                        CheckServerAuthResult checkServerAuthResult = new CheckServerAuthResult(checkResult.zznl(), checkResult.zznm());
                        zzf2.zza(checkServerAuthResult);
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"SignInClientImpl", (String)"RemoteException thrown when processing checkServerAuthorization callback", (Throwable)remoteException);
                    }
                }
            });
        }

        @Override
        public void zza(final String string, final String string2, final zzf zzf2) throws RemoteException {
            this.zzaOo.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean bl = zza.this.zzzq().onUploadServerAuthCode(string, string2);
                        zzf2.zzaq(bl);
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"SignInClientImpl", (String)"RemoteException thrown when processing uploadServerAuthCode callback", (Throwable)remoteException);
                    }
                }
            });
        }

        private GoogleApiClient.ServerAuthCodeCallbacks zzzq() throws RemoteException {
            return this.zzade.zzzq();
        }
    }
}

