/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import java.util.LinkedHashMap;
import java.util.Map;

public class zzlf<K, V> {
    private final LinkedHashMap<K, V> zzaex;
    private int size;
    private int zzaey;
    private int zzaez;
    private int zzaeA;
    private int zzaeB;
    private int zzaeC;
    private int zzaeD;

    public zzlf(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.zzaey = n;
        this.zzaex = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K key) {
        Object object;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        zzlf<K, V> zzlf2 = this;
        synchronized (zzlf2) {
            object = this.zzaex.get(key);
            if (object != null) {
                ++this.zzaeC;
                return object;
            }
            ++this.zzaeD;
        }
        zzlf2 = this.create(key);
        if (zzlf2 == null) {
            return null;
        }
        zzlf zzlf3 = this;
        synchronized (zzlf3) {
            ++this.zzaeA;
            object = this.zzaex.put(key, zzlf2);
            if (object != null) {
                this.zzaex.put(key, object);
            } else {
                this.size += this.zzc(key, zzlf2);
            }
        }
        if (object != null) {
            this.entryRemoved(false, key, zzlf2, object);
            return object;
        }
        this.trimToSize(this.zzaey);
        return (V)zzlf2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K key, V value) {
        V v;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        zzlf zzlf2 = this;
        synchronized (zzlf2) {
            ++this.zzaez;
            this.size += this.zzc(key, value);
            v = this.zzaex.put(key, value);
            if (v != null) {
                this.size -= this.zzc(key, v);
            }
        }
        if (v != null) {
            this.entryRemoved(false, key, v, value);
        }
        this.trimToSize(this.zzaey);
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize(int maxSize) {
        while (true) {
            V v;
            K k;
            zzlf zzlf2 = this;
            synchronized (zzlf2) {
                if (this.size < 0 || this.zzaex.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize || this.zzaex.isEmpty()) {
                    break;
                }
                Map.Entry<K, V> entry = this.zzaex.entrySet().iterator().next();
                k = entry.getKey();
                v = entry.getValue();
                this.zzaex.remove(k);
                this.size -= this.zzc(k, v);
                ++this.zzaeB;
            }
            this.entryRemoved(true, k, v, null);
        }
    }

    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
    }

    protected V create(K key) {
        return null;
    }

    private int zzc(K k, V v) {
        int n = this.sizeOf(k, v);
        if (n < 0) {
            throw new IllegalStateException("Negative size: " + k + "=" + v);
        }
        return n;
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized String toString() {
        int n = this.zzaeC + this.zzaeD;
        int n2 = n != 0 ? 100 * this.zzaeC / n : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.zzaey, this.zzaeC, this.zzaeD, n2);
    }
}

