/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.server.converter.ConverterWrapper;
import com.google.android.gms.common.server.response.FieldMappingDictionary;
import com.google.android.gms.common.server.response.SafeParcelResponse;
import com.google.android.gms.internal.zzlj;
import com.google.android.gms.internal.zzls;
import com.google.android.gms.internal.zzlt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class FastJsonResponse {
    public abstract Map<String, Field<?, ?>> zzpb();

    protected abstract Object zzct(String var1);

    protected boolean zza(Field field) {
        if (field.zzpa() == 11) {
            if (field.zzpg()) {
                return this.zzcw(field.zzph());
            }
            return this.zzcv(field.zzph());
        }
        return this.zzcu(field.zzph());
    }

    protected abstract boolean zzcu(String var1);

    protected boolean zzcv(String string2) {
        throw new UnsupportedOperationException("Concrete types not supported");
    }

    protected boolean zzcw(String string2) {
        throw new UnsupportedOperationException("Concrete type arrays not supported");
    }

    protected <O, I> I zza(Field<I, O> field, Object object) {
        if (((Field)field).zzaeZ != null) {
            return field.convertBack(object);
        }
        return (I)object;
    }

    public HashMap<String, Object> zzpc() {
        return null;
    }

    public HashMap<String, Object> zzpd() {
        return null;
    }

    public String toString() {
        Map<String, Field<?, ?>> map = this.zzpb();
        StringBuilder stringBuilder = new StringBuilder(100);
        block5: for (String string2 : map.keySet()) {
            Field<?, ?> field = map.get(string2);
            if (!this.zza(field)) continue;
            Object object = this.zzb(field);
            Object obj = this.zza(field, object);
            if (stringBuilder.length() == 0) {
                stringBuilder.append("{");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"").append(string2).append("\":");
            if (obj == null) {
                stringBuilder.append("null");
                continue;
            }
            switch (field.zzpa()) {
                case 8: {
                    stringBuilder.append("\"").append(zzlj.zzi((byte[])obj)).append("\"");
                    continue block5;
                }
                case 9: {
                    stringBuilder.append("\"").append(zzlj.zzj((byte[])obj)).append("\"");
                    continue block5;
                }
                case 10: {
                    HashMap hashMap = (HashMap)obj;
                    zzlt.zza(stringBuilder, hashMap);
                    continue block5;
                }
            }
            if (field.zzpf()) {
                this.zza(stringBuilder, field, (ArrayList)obj);
                continue;
            }
            this.zza(stringBuilder, field, obj);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("}");
        } else {
            stringBuilder.append("{}");
        }
        return stringBuilder.toString();
    }

    protected Object zzb(Field field) {
        String string2 = field.zzph();
        if (field.zzpj() != null) {
            HashMap<String, Object> hashMap;
            zzx.zza(this.zzct(field.zzph()) == null, "Concrete field shouldn't be value object: %s", field.zzph());
            HashMap<String, Object> hashMap2 = hashMap = field.zzpg() ? this.zzpd() : this.zzpc();
            if (hashMap != null) {
                return hashMap.get(string2);
            }
            try {
                String string3 = "get" + Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
                return this.getClass().getMethod(string3, new Class[0]).invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.zzct(field.zzph());
    }

    private void zza(StringBuilder stringBuilder, Field field, Object object) {
        if (field.zzoZ() == 11) {
            Class<FastJsonResponse> clazz = field.zzpj();
            stringBuilder.append(clazz.cast(object).toString());
        } else if (field.zzoZ() == 7) {
            stringBuilder.append("\"");
            stringBuilder.append(zzls.zzcA((String)object));
            stringBuilder.append("\"");
        } else {
            stringBuilder.append(object);
        }
    }

    private void zza(StringBuilder stringBuilder, Field field, ArrayList<Object> arrayList) {
        stringBuilder.append("[");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            if (i > 0) {
                stringBuilder.append(",");
            }
            if ((object = arrayList.get(i)) == null) continue;
            this.zza(stringBuilder, field, object);
        }
        stringBuilder.append("]");
    }

    public static interface zza<I, O> {
        public int zzoZ();

        public int zzpa();

        public I convertBack(O var1);
    }

    public static class Field<I, O>
    implements SafeParcelable {
        private final int mVersionCode;
        protected final int zzaeQ;
        protected final boolean zzaeR;
        protected final int zzaeS;
        protected final boolean zzaeT;
        protected final String zzaeU;
        protected final int zzaeV;
        protected final Class<? extends FastJsonResponse> zzaeW;
        protected final String zzaeX;
        private FieldMappingDictionary zzaeY;
        private zza<I, O> zzaeZ;
        public static final com.google.android.gms.common.server.response.zza CREATOR = new com.google.android.gms.common.server.response.zza();

        Field(int versionCode, int typeIn, boolean typeInArray, int typeOut, boolean typeOutArray, String outputFieldName, int safeParcelableFieldId, String concreteTypeName, ConverterWrapper wrappedConverter) {
            this.mVersionCode = versionCode;
            this.zzaeQ = typeIn;
            this.zzaeR = typeInArray;
            this.zzaeS = typeOut;
            this.zzaeT = typeOutArray;
            this.zzaeU = outputFieldName;
            this.zzaeV = safeParcelableFieldId;
            if (concreteTypeName == null) {
                this.zzaeW = null;
                this.zzaeX = null;
            } else {
                this.zzaeW = SafeParcelResponse.class;
                this.zzaeX = concreteTypeName;
            }
            this.zzaeZ = wrappedConverter == null ? null : wrappedConverter.zzoX();
        }

        protected Field(int typeIn, boolean typeInArray, int typeOut, boolean typeOutArray, String outputFieldName, int safeParcelableFieldId, Class<? extends FastJsonResponse> concreteType, zza<I, O> converter) {
            this.mVersionCode = 1;
            this.zzaeQ = typeIn;
            this.zzaeR = typeInArray;
            this.zzaeS = typeOut;
            this.zzaeT = typeOutArray;
            this.zzaeU = outputFieldName;
            this.zzaeV = safeParcelableFieldId;
            this.zzaeW = concreteType;
            this.zzaeX = concreteType == null ? null : concreteType.getCanonicalName();
            this.zzaeZ = converter;
        }

        public Field<I, O> zzpe() {
            return new Field<I, O>(this.mVersionCode, this.zzaeQ, this.zzaeR, this.zzaeS, this.zzaeT, this.zzaeU, this.zzaeV, this.zzaeX, this.zzpm());
        }

        public int getVersionCode() {
            return this.mVersionCode;
        }

        public int zzoZ() {
            return this.zzaeQ;
        }

        public boolean zzpf() {
            return this.zzaeR;
        }

        public int zzpa() {
            return this.zzaeS;
        }

        public boolean zzpg() {
            return this.zzaeT;
        }

        public String zzph() {
            return this.zzaeU;
        }

        public int zzpi() {
            return this.zzaeV;
        }

        public Class<? extends FastJsonResponse> zzpj() {
            return this.zzaeW;
        }

        String zzpk() {
            if (this.zzaeX == null) {
                return null;
            }
            return this.zzaeX;
        }

        public boolean zzpl() {
            return this.zzaeZ != null;
        }

        public void zza(FieldMappingDictionary fieldMappingDictionary) {
            this.zzaeY = fieldMappingDictionary;
        }

        ConverterWrapper zzpm() {
            if (this.zzaeZ == null) {
                return null;
            }
            return ConverterWrapper.zza(this.zzaeZ);
        }

        public Map<String, Field<?, ?>> zzpn() {
            zzx.zzv(this.zzaeX);
            zzx.zzv(this.zzaeY);
            return this.zzaeY.zzcx(this.zzaeX);
        }

        public I convertBack(O output) {
            return this.zzaeZ.convertBack(output);
        }

        public static Field<Integer, Integer> zzj(String string2, int n) {
            return new Field<Integer, Integer>(0, false, 0, false, string2, n, null, null);
        }

        public static Field<Double, Double> zzk(String string2, int n) {
            return new Field<Double, Double>(4, false, 4, false, string2, n, null, null);
        }

        public static Field<Boolean, Boolean> zzl(String string2, int n) {
            return new Field<Boolean, Boolean>(6, false, 6, false, string2, n, null, null);
        }

        public static Field<String, String> zzm(String string2, int n) {
            return new Field<String, String>(7, false, 7, false, string2, n, null, null);
        }

        public static Field<ArrayList<String>, ArrayList<String>> zzn(String string2, int n) {
            return new Field<ArrayList<String>, ArrayList<String>>(7, true, 7, true, string2, n, null, null);
        }

        public static <T extends FastJsonResponse> Field<T, T> zza(String string2, int n, Class<T> clazz) {
            return new Field(11, false, 11, false, string2, n, clazz, null);
        }

        public static <T extends FastJsonResponse> Field<ArrayList<T>, ArrayList<T>> zzb(String string2, int n, Class<T> clazz) {
            return new Field<ArrayList<T>, ArrayList<T>>(11, true, 11, true, string2, n, clazz, null);
        }

        public static Field zza(String string2, int n, zza<?, ?> zza2, boolean bl) {
            return new Field(zza2.zzoZ(), bl, zza2.zzpa(), false, string2, n, null, zza2);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            com.google.android.gms.common.server.response.zza.zza(this, out, flags);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Field\n");
            stringBuilder.append("            versionCode=").append(this.mVersionCode).append('\n');
            stringBuilder.append("                 typeIn=").append(this.zzaeQ).append('\n');
            stringBuilder.append("            typeInArray=").append(this.zzaeR).append('\n');
            stringBuilder.append("                typeOut=").append(this.zzaeS).append('\n');
            stringBuilder.append("           typeOutArray=").append(this.zzaeT).append('\n');
            stringBuilder.append("        outputFieldName=").append(this.zzaeU).append('\n');
            stringBuilder.append("      safeParcelFieldId=").append(this.zzaeV).append('\n');
            stringBuilder.append("       concreteTypeName=").append(this.zzpk()).append('\n');
            if (this.zzpj() != null) {
                stringBuilder.append("     concreteType.class=").append(this.zzpj().getCanonicalName()).append('\n');
            }
            stringBuilder.append("          converterName=").append(this.zzaeZ == null ? "null" : this.zzaeZ.getClass().getCanonicalName()).append('\n');
            return stringBuilder.toString();
        }
    }
}

