/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.data.zza;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class BitmapTeleporter
implements SafeParcelable {
    public static final Parcelable.Creator<BitmapTeleporter> CREATOR = new zza();
    final int mVersionCode;
    ParcelFileDescriptor zzEo;
    final int zzUS;
    private Bitmap zzaba;
    private boolean zzabb;
    private File zzabc;

    BitmapTeleporter(int versionCode, ParcelFileDescriptor parcelFileDescriptor, int type) {
        this.mVersionCode = versionCode;
        this.zzEo = parcelFileDescriptor;
        this.zzUS = type;
        this.zzaba = null;
        this.zzabb = false;
    }

    public BitmapTeleporter(Bitmap teleportee) {
        this.mVersionCode = 1;
        this.zzEo = null;
        this.zzUS = 0;
        this.zzaba = teleportee;
        this.zzabb = true;
    }

    public Bitmap zznQ() {
        if (!this.zzabb) {
            Bitmap.Config config;
            int n;
            int n2;
            byte[] byArray;
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzEo));
            try {
                byArray = new byte[dataInputStream.readInt()];
                n2 = dataInputStream.readInt();
                n = dataInputStream.readInt();
                config = Bitmap.Config.valueOf((String)dataInputStream.readUTF());
                dataInputStream.read(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                this.zza(dataInputStream);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n, (Bitmap.Config)config);
            bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
            this.zzaba = bitmap;
            this.zzabb = true;
        }
        return this.zzaba;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.zzEo == null) {
            Bitmap bitmap = this.zzaba;
            ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getRowBytes() * bitmap.getHeight());
            bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
            byte[] byArray = byteBuffer.array();
            FileOutputStream fileOutputStream = this.zznR();
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            try {
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.writeInt(bitmap.getWidth());
                dataOutputStream.writeInt(bitmap.getHeight());
                dataOutputStream.writeUTF(bitmap.getConfig().toString());
                dataOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not write into unlinked file", iOException);
            }
            finally {
                this.zza(dataOutputStream);
            }
        }
        zza.zza(this, dest, flags | 1);
        this.zzEo = null;
    }

    public void release() {
        if (!this.zzabb) {
            try {
                this.zzEo.close();
            }
            catch (IOException iOException) {
                Log.w((String)"BitmapTeleporter", (String)"Could not close PFD", (Throwable)iOException);
            }
        }
    }

    public void zzc(File file) {
        if (file == null) {
            throw new NullPointerException("Cannot set null temp directory");
        }
        this.zzabc = file;
    }

    private FileOutputStream zznR() {
        FileOutputStream fileOutputStream;
        File file;
        if (this.zzabc == null) {
            throw new IllegalStateException("setTempDir() must be called before writing this object to a parcel");
        }
        try {
            file = File.createTempFile("teleporter", ".tmp", this.zzabc);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not create temporary file", iOException);
        }
        try {
            fileOutputStream = new FileOutputStream(file);
            this.zzEo = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalStateException("Temporary file is somehow already deleted");
        }
        file.delete();
        return fileOutputStream;
    }

    private void zza(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            Log.w((String)"BitmapTeleporter", (String)"Could not close stream", (Throwable)iOException);
        }
    }
}

