/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzl;
import com.google.android.gms.maps.internal.zzy;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb zzaGb;
    private GoogleMap zzaFV;

    public MapView(Context context) {
        super(context);
        this.zzaGb = new zzb((ViewGroup)this, context, null);
        this.init();
    }

    public MapView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.zzaGb = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attrs));
        this.init();
    }

    public MapView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.zzaGb = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attrs));
        this.init();
    }

    public MapView(Context context, GoogleMapOptions options) {
        super(context);
        this.zzaGb = new zzb((ViewGroup)this, context, options);
        this.init();
    }

    private void init() {
        this.setClickable(true);
    }

    @Deprecated
    public final GoogleMap getMap() {
        if (this.zzaFV != null) {
            return this.zzaFV;
        }
        this.zzaGb.zzwP();
        if (this.zzaGb.zzrn() == null) {
            return null;
        }
        try {
            this.zzaFV = new GoogleMap(((zza)this.zzaGb.zzrn()).zzwQ().getMap());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return this.zzaFV;
    }

    public final void onCreate(Bundle savedInstanceState) {
        this.zzaGb.onCreate(savedInstanceState);
        if (this.zzaGb.zzrn() == null) {
            com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
        }
    }

    public final void onResume() {
        this.zzaGb.onResume();
    }

    public final void onPause() {
        this.zzaGb.onPause();
    }

    public final void onDestroy() {
        this.zzaGb.onDestroy();
    }

    public final void onLowMemory() {
        this.zzaGb.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle outState) {
        this.zzaGb.onSaveInstanceState(outState);
    }

    public void getMapAsync(OnMapReadyCallback callback) {
        zzx.zzch((String)"getMapAsync() must be called on the main thread");
        this.zzaGb.getMapAsync(callback);
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zzaGg;
        private final Context mContext;
        protected zzf<zza> zzaFZ;
        private final GoogleMapOptions zzaGh;
        private final List<OnMapReadyCallback> zzaGa = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.zzaGg = viewGroup;
            this.mContext = context;
            this.zzaGh = googleMapOptions;
        }

        protected void zza(zzf<zza> zzf2) {
            this.zzaFZ = zzf2;
            this.zzwP();
        }

        public void zzwP() {
            if (this.zzaFZ != null && this.zzrn() == null) {
                try {
                    MapsInitializer.initialize(this.mContext);
                    IMapViewDelegate iMapViewDelegate = zzy.zzaF(this.mContext).zza(zze.zzx((Object)this.mContext), this.zzaGh);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    this.zzaFZ.zza((LifecycleDelegate)new zza(this.zzaGg, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzaGa) {
                        ((zza)this.zzrn()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzaGa.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        public void getMapAsync(OnMapReadyCallback callback) {
            if (this.zzrn() != null) {
                ((zza)this.zzrn()).getMapAsync(callback);
            } else {
                this.zzaGa.add(callback);
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final ViewGroup zzaGc;
        private final IMapViewDelegate zzaGd;
        private View zzaGe;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.zzaGd = (IMapViewDelegate)zzx.zzv((Object)iMapViewDelegate);
            this.zzaGc = (ViewGroup)zzx.zzv((Object)viewGroup);
        }

        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public void onCreate(Bundle savedInstanceState) {
            try {
                this.zzaGd.onCreate(savedInstanceState);
                this.zzaGe = (View)zze.zzp((zzd)this.zzaGd.getView());
                this.zzaGc.removeAllViews();
                this.zzaGc.addView(this.zzaGe);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public void onStart() {
        }

        public void onResume() {
            try {
                this.zzaGd.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzaGd.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
        }

        public void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public void onDestroy() {
            try {
                this.zzaGd.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.zzaGd.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzaGd.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapViewDelegate zzwQ() {
            return this.zzaGd;
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback callback) {
            try {
                this.zzaGd.getMapAsync(new zzl.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        callback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

