/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.SearchAdRequestParcel;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.appdatasearch.DocumentContents;
import com.google.android.gms.appdatasearch.DocumentSection;
import com.google.android.gms.appdatasearch.GetRecentContextCall;
import com.google.android.gms.appdatasearch.UsageInfo;
import com.google.android.gms.appdatasearch.zza;
import com.google.android.gms.appindexing.AndroidAppUri;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.internal.zzbr;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzgm;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzgt;
import com.google.android.gms.internal.zzhp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzgk
public final class zzgn {
    private static final SimpleDateFormat zzEY = new SimpleDateFormat("yyyyMMdd", Locale.US);

    public static JSONObject zza(Context context, AdRequestInfoParcel adRequestInfoParcel, zzgr zzgr2, zzgt.zza zza2, Location location, zzbr zzbr2, String string2, String string3, List<String> list) {
        try {
            CharSequence charSequence;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (list.size() > 0) {
                hashMap.put("eid", TextUtils.join((CharSequence)",", list));
            }
            if (adRequestInfoParcel.zzDx != null) {
                hashMap.put("ad_pos", adRequestInfoParcel.zzDx);
            }
            zzgn.zza(hashMap, adRequestInfoParcel.zzDy);
            hashMap.put("format", adRequestInfoParcel.zzqf.zzsG);
            if (adRequestInfoParcel.zzqf.width == -1) {
                hashMap.put("smart_w", "full");
            }
            if (adRequestInfoParcel.zzqf.height == -2) {
                hashMap.put("smart_h", "auto");
            }
            if (adRequestInfoParcel.zzqf.zzsI != null) {
                charSequence = new StringBuilder();
                for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzqf.zzsI) {
                    if (charSequence.length() != 0) {
                        charSequence.append("|");
                    }
                    charSequence.append(adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / zzgr2.zzDK) : adSizeParcel.width);
                    charSequence.append("x");
                    charSequence.append(adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / zzgr2.zzDK) : adSizeParcel.height);
                }
                hashMap.put("sz", charSequence);
            }
            if (adRequestInfoParcel.zzDE != 0) {
                hashMap.put("native_version", adRequestInfoParcel.zzDE);
                hashMap.put("native_templates", adRequestInfoParcel.zzqv);
                hashMap.put("native_image_orientation", zzgn.zzc(adRequestInfoParcel.zzqt));
                if (!adRequestInfoParcel.zzDS.isEmpty()) {
                    hashMap.put("native_custom_templates", adRequestInfoParcel.zzDS);
                }
            }
            hashMap.put("slotname", adRequestInfoParcel.zzpZ);
            hashMap.put("pn", adRequestInfoParcel.applicationInfo.packageName);
            if (adRequestInfoParcel.zzDz != null) {
                hashMap.put("vc", adRequestInfoParcel.zzDz.versionCode);
            }
            hashMap.put("ms", string3);
            hashMap.put("seq_num", adRequestInfoParcel.zzDB);
            hashMap.put("session_id", adRequestInfoParcel.zzDC);
            hashMap.put("js", adRequestInfoParcel.zzqb.zzIz);
            zzgn.zza(hashMap, zzgr2, zza2);
            hashMap.put("fdz", zzbr2.zzdc());
            hashMap.put("platform", Build.MANUFACTURER);
            hashMap.put("submodel", Build.MODEL);
            if (adRequestInfoParcel.zzDy.versionCode >= 2 && adRequestInfoParcel.zzDy.zzsy != null) {
                zzgn.zza(hashMap, adRequestInfoParcel.zzDy.zzsy);
            }
            if (adRequestInfoParcel.versionCode >= 2) {
                hashMap.put("quality_signals", adRequestInfoParcel.zzDD);
            }
            if (adRequestInfoParcel.versionCode >= 4 && adRequestInfoParcel.zzDG) {
                hashMap.put("forceHttps", adRequestInfoParcel.zzDG);
            }
            if (adRequestInfoParcel.versionCode >= 4 && adRequestInfoParcel.zzDF != null) {
                charSequence = adRequestInfoParcel.zzDF;
                zzgn.zza(context, adRequestInfoParcel, (Bundle)charSequence);
                hashMap.put("content_info", charSequence);
            }
            if (adRequestInfoParcel.versionCode >= 5) {
                hashMap.put("u_sd", Float.valueOf(adRequestInfoParcel.zzDK));
                hashMap.put("sh", adRequestInfoParcel.zzDJ);
                hashMap.put("sw", adRequestInfoParcel.zzDI);
            } else {
                hashMap.put("u_sd", Float.valueOf(zzgr2.zzDK));
                hashMap.put("sh", zzgr2.zzDJ);
                hashMap.put("sw", zzgr2.zzDI);
            }
            if (adRequestInfoParcel.versionCode >= 6) {
                if (!TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzDL)) {
                    try {
                        hashMap.put("view_hierarchy", new JSONObject(adRequestInfoParcel.zzDL));
                    }
                    catch (JSONException jSONException) {
                        zzb.zzd("Problem serializing view hierarchy to JSON", jSONException);
                    }
                }
                if (zzby.zzuQ.get().booleanValue() && adRequestInfoParcel.zzDM) {
                    hashMap.put("ga_hid", adRequestInfoParcel.zzDN);
                    hashMap.put("ga_cid", adRequestInfoParcel.zzDO);
                }
                hashMap.put("correlation_id", adRequestInfoParcel.zzDP);
            }
            if (adRequestInfoParcel.versionCode >= 7) {
                hashMap.put("request_id", adRequestInfoParcel.zzDQ);
            }
            if (adRequestInfoParcel.versionCode >= 11 && adRequestInfoParcel.zzDU != null) {
                hashMap.put("capability", adRequestInfoParcel.zzDU.toBundle());
            }
            zzgn.zza(hashMap, string2);
            if (zzb.zzM(2)) {
                charSequence = zzp.zzbx().zzx(hashMap).toString(2);
                zzb.v("Ad Request JSON: " + (String)charSequence);
            }
            return zzp.zzbx().zzx(hashMap);
        }
        catch (JSONException jSONException) {
            zzb.zzaE("Problem serializing ad request to JSON: " + jSONException.getMessage());
            return null;
        }
    }

    static void zza(Context context, AdRequestInfoParcel adRequestInfoParcel, Bundle bundle) {
        if (!zzby.zzuK.get().booleanValue()) {
            zzb.zzaD("App index is not enabled");
            return;
        }
        if (!zzd.zzacF) {
            zzb.zzaD("Not on package side, return");
            return;
        }
        if (zzk.zzcE().zzgI()) {
            zzb.zzaD("Cannot invoked on UI thread");
            return;
        }
        if (adRequestInfoParcel == null || adRequestInfoParcel.zzDz == null) {
            zzb.zzaE("Invalid ad request info");
            return;
        }
        String string2 = adRequestInfoParcel.zzDz.packageName;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzb.zzaE("Fail to get package name");
            return;
        }
        try {
            UsageInfo usageInfo = zzgn.zzd(context, string2);
            zzgn.zza(usageInfo, string2, bundle);
        }
        catch (RuntimeException runtimeException) {
            zzb.zzaD("Fail to add app index to content info");
        }
    }

    static void zza(UsageInfo usageInfo, String string2, Bundle bundle) {
        if (usageInfo == null || usageInfo.zzle() == null) {
            return;
        }
        DocumentContents documentContents = usageInfo.zzle();
        String string3 = documentContents.zzkX();
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            bundle.putString("web_url", string3);
        }
        try {
            DocumentSection documentSection = documentContents.zzbu("intent_data");
            if (documentSection != null && !TextUtils.isEmpty((CharSequence)documentSection.zzPe)) {
                Uri uri = Uri.parse((String)documentSection.zzPe);
                AndroidAppUri androidAppUri = AndroidAppUri.newAndroidAppUri((String)string2, (Uri)uri);
                bundle.putString("app_uri", androidAppUri.toString());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            zzb.zzaE("Failed to parse the third-party Android App URI");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UsageInfo zzd(Context context, String string2) {
        GoogleApiClient googleApiClient = null;
        UsageInfo usageInfo = null;
        try {
            googleApiClient = new GoogleApiClient.Builder(context).addApi(zza.zzOQ).build();
            googleApiClient.connect();
            GetRecentContextCall.Request request = new GetRecentContextCall.Request.zza().zzL(true).zzbw(string2).zzlb();
            GetRecentContextCall.Response response = (GetRecentContextCall.Response)zza.zzOR.zza(googleApiClient, request).await(1L, TimeUnit.SECONDS);
            if (response == null || !response.getStatus().isSuccess()) {
                zzb.zzaD("Fail to obtain recent context call");
                UsageInfo usageInfo2 = null;
                return usageInfo2;
            }
            if (response.zzPw == null || response.zzPw.isEmpty()) {
                zzb.zzaD("Fail to obtain recent context");
                UsageInfo usageInfo3 = null;
                return usageInfo3;
            }
            usageInfo = (UsageInfo)response.zzPw.get(0);
        }
        catch (SecurityException securityException) {
            zzb.zzaE("Fail to get recent context");
        }
        finally {
            if (googleApiClient != null) {
                googleApiClient.disconnect();
            }
        }
        return usageInfo;
    }

    private static void zza(HashMap<String, Object> hashMap, String string2) {
        if (string2 != null) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("token", string2);
            hashMap.put("pan", hashMap2);
        }
    }

    private static void zza(HashMap<String, Object> hashMap, AdRequestParcel adRequestParcel) {
        String string2 = zzhp.zzgm();
        if (string2 != null) {
            hashMap.put("abf", string2);
        }
        if (adRequestParcel.zzsq != -1L) {
            hashMap.put("cust_age", zzEY.format(new Date(adRequestParcel.zzsq)));
        }
        if (adRequestParcel.extras != null) {
            hashMap.put("extras", adRequestParcel.extras);
        }
        if (adRequestParcel.zzsr != -1) {
            hashMap.put("cust_gender", adRequestParcel.zzsr);
        }
        if (adRequestParcel.zzss != null) {
            hashMap.put("kw", adRequestParcel.zzss);
        }
        if (adRequestParcel.zzsu != -1) {
            hashMap.put("tag_for_child_directed_treatment", adRequestParcel.zzsu);
        }
        if (adRequestParcel.zzst) {
            hashMap.put("adtest", "on");
        }
        if (adRequestParcel.versionCode >= 2) {
            if (adRequestParcel.zzsv) {
                hashMap.put("d_imp_hdr", 1);
            }
            if (!TextUtils.isEmpty((CharSequence)adRequestParcel.zzsw)) {
                hashMap.put("ppid", adRequestParcel.zzsw);
            }
            if (adRequestParcel.zzsx != null) {
                zzgn.zza(hashMap, adRequestParcel.zzsx);
            }
        }
        if (adRequestParcel.versionCode >= 3 && adRequestParcel.zzsz != null) {
            hashMap.put("url", adRequestParcel.zzsz);
        }
        if (adRequestParcel.versionCode >= 5) {
            if (adRequestParcel.zzsB != null) {
                hashMap.put("custom_targeting", adRequestParcel.zzsB);
            }
            if (adRequestParcel.zzsC != null) {
                hashMap.put("category_exclusions", adRequestParcel.zzsC);
            }
            if (adRequestParcel.zzsD != null) {
                hashMap.put("request_agent", adRequestParcel.zzsD);
            }
        }
        if (adRequestParcel.versionCode >= 6 && adRequestParcel.zzsE != null) {
            hashMap.put("request_pkg", adRequestParcel.zzsE);
        }
    }

    private static void zza(HashMap<String, Object> hashMap, zzgr zzgr2, zzgt.zza zza2) {
        hashMap.put("am", zzgr2.zzFB);
        hashMap.put("cog", zzgn.zzx(zzgr2.zzFC));
        hashMap.put("coh", zzgn.zzx(zzgr2.zzFD));
        if (!TextUtils.isEmpty((CharSequence)zzgr2.zzFE)) {
            hashMap.put("carrier", zzgr2.zzFE);
        }
        hashMap.put("gl", zzgr2.zzFF);
        if (zzgr2.zzFG) {
            hashMap.put("simulator", 1);
        }
        if (zzgr2.zzFH) {
            hashMap.put("is_sidewinder", 1);
        }
        hashMap.put("ma", zzgn.zzx(zzgr2.zzFI));
        hashMap.put("sp", zzgn.zzx(zzgr2.zzFJ));
        hashMap.put("hl", zzgr2.zzFK);
        if (!TextUtils.isEmpty((CharSequence)zzgr2.zzFL)) {
            hashMap.put("mv", zzgr2.zzFL);
        }
        hashMap.put("muv", zzgr2.zzFM);
        if (zzgr2.zzFN != -2) {
            hashMap.put("cnt", zzgr2.zzFN);
        }
        hashMap.put("gnt", zzgr2.zzFO);
        hashMap.put("pt", zzgr2.zzFP);
        hashMap.put("rm", zzgr2.zzFQ);
        hashMap.put("riv", zzgr2.zzFR);
        Bundle bundle = new Bundle();
        bundle.putString("build", zzgr2.zzFW);
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("is_charging", zzgr2.zzFT);
        bundle2.putDouble("battery_level", zzgr2.zzFS);
        bundle.putBundle("battery", bundle2);
        Bundle bundle3 = new Bundle();
        bundle3.putInt("active_network_state", zzgr2.zzFV);
        bundle3.putBoolean("active_network_metered", zzgr2.zzFU);
        if (zza2 != null) {
            Bundle bundle4 = new Bundle();
            bundle4.putInt("predicted_latency_micros", zza2.zzGb);
            bundle4.putLong("predicted_down_throughput_bps", zza2.zzGc);
            bundle4.putLong("predicted_up_throughput_bps", zza2.zzGd);
            bundle3.putBundle("predictions", bundle4);
        }
        bundle.putBundle("network", bundle3);
        hashMap.put("device", bundle);
    }

    private static void zza(HashMap<String, Object> hashMap, Location location) {
        HashMap<String, Number> hashMap2 = new HashMap<String, Number>();
        Float f = Float.valueOf(location.getAccuracy() * 1000.0f);
        Long l = location.getTime() * 1000L;
        Long l2 = (long)(location.getLatitude() * 1.0E7);
        Long l3 = (long)(location.getLongitude() * 1.0E7);
        hashMap2.put("radius", f);
        hashMap2.put("lat", l2);
        hashMap2.put("long", l3);
        hashMap2.put("time", l);
        hashMap.put("uule", hashMap2);
    }

    private static void zza(HashMap<String, Object> hashMap, SearchAdRequestParcel searchAdRequestParcel) {
        String string2;
        String string3;
        if (Color.alpha((int)searchAdRequestParcel.zztA) != 0) {
            hashMap.put("acolor", zzgn.zzH(searchAdRequestParcel.zztA));
        }
        if (Color.alpha((int)searchAdRequestParcel.backgroundColor) != 0) {
            hashMap.put("bgcolor", zzgn.zzH(searchAdRequestParcel.backgroundColor));
        }
        if (Color.alpha((int)searchAdRequestParcel.zztB) != 0 && Color.alpha((int)searchAdRequestParcel.zztC) != 0) {
            hashMap.put("gradientto", zzgn.zzH(searchAdRequestParcel.zztB));
            hashMap.put("gradientfrom", zzgn.zzH(searchAdRequestParcel.zztC));
        }
        if (Color.alpha((int)searchAdRequestParcel.zztD) != 0) {
            hashMap.put("bcolor", zzgn.zzH(searchAdRequestParcel.zztD));
        }
        hashMap.put("bthick", Integer.toString(searchAdRequestParcel.zztE));
        switch (searchAdRequestParcel.zztF) {
            case 0: {
                string3 = "none";
                break;
            }
            case 1: {
                string3 = "dashed";
                break;
            }
            case 2: {
                string3 = "dotted";
                break;
            }
            case 3: {
                string3 = "solid";
                break;
            }
            default: {
                string3 = null;
            }
        }
        if (string3 != null) {
            hashMap.put("btype", string3);
        }
        switch (searchAdRequestParcel.zztG) {
            case 2: {
                string2 = "dark";
                break;
            }
            case 0: {
                string2 = "light";
                break;
            }
            case 1: {
                string2 = "medium";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            hashMap.put("callbuttoncolor", string2);
        }
        if (searchAdRequestParcel.zztH != null) {
            hashMap.put("channel", searchAdRequestParcel.zztH);
        }
        if (Color.alpha((int)searchAdRequestParcel.zztI) != 0) {
            hashMap.put("dcolor", zzgn.zzH(searchAdRequestParcel.zztI));
        }
        if (searchAdRequestParcel.zztJ != null) {
            hashMap.put("font", searchAdRequestParcel.zztJ);
        }
        if (Color.alpha((int)searchAdRequestParcel.zztK) != 0) {
            hashMap.put("hcolor", zzgn.zzH(searchAdRequestParcel.zztK));
        }
        hashMap.put("headersize", Integer.toString(searchAdRequestParcel.zztL));
        if (searchAdRequestParcel.zztM != null) {
            hashMap.put("q", searchAdRequestParcel.zztM);
        }
    }

    private static Integer zzx(boolean bl) {
        return bl ? 1 : 0;
    }

    private static String zzH(int n) {
        return String.format(Locale.US, "#%06x", n & 0xFFFFFF);
    }

    private static String zzc(NativeAdOptionsParcel nativeAdOptionsParcel) {
        int n = nativeAdOptionsParcel != null ? nativeAdOptionsParcel.zzwo : 0;
        switch (n) {
            case 1: {
                return "portrait";
            }
            case 2: {
                return "landscape";
            }
        }
        return "any";
    }

    public static AdResponseParcel zza(Context context, AdRequestInfoParcel adRequestInfoParcel, String string2) {
        try {
            List<String> list;
            List<String> list2;
            List<String> list3;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("ad_base_url", null);
            String string4 = jSONObject.optString("ad_url", null);
            String string5 = jSONObject.optString("ad_size", null);
            boolean bl = adRequestInfoParcel != null && adRequestInfoParcel.zzDE != 0;
            String string6 = bl ? jSONObject.optString("ad_json", null) : jSONObject.optString("ad_html", null);
            long l = -1L;
            String string7 = jSONObject.optString("debug_dialog", null);
            long l2 = jSONObject.has("interstitial_timeout") ? (long)(jSONObject.getDouble("interstitial_timeout") * 1000.0) : -1L;
            String string8 = jSONObject.optString("orientation", null);
            int n = -1;
            if ("portrait".equals(string8)) {
                n = zzp.zzbz().zzgw();
            } else if ("landscape".equals(string8)) {
                n = zzp.zzbz().zzgv();
            }
            AdResponseParcel adResponseParcel = null;
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    zzb.zzaE("Could not parse the mediation config: Missing required ad_base_url field");
                    return new AdResponseParcel(0);
                }
            } else if (!TextUtils.isEmpty((CharSequence)string4)) {
                adResponseParcel = zzgm.zza(adRequestInfoParcel, context, adRequestInfoParcel.zzqb.zzIz, string4, null, null, null, null);
                string3 = adResponseParcel.zzAT;
                string6 = adResponseParcel.body;
                l = adResponseParcel.zzEb;
            } else {
                zzb.zzaE("Could not parse the mediation config: Missing required " + (bl ? "ad_json" : "ad_html") + " or " + "ad_url" + " field.");
                return new AdResponseParcel(0);
            }
            JSONArray jSONArray = jSONObject.optJSONArray("click_urls");
            List<String> list4 = list3 = adResponseParcel == null ? null : adResponseParcel.zzyw;
            if (jSONArray != null) {
                if (list3 == null) {
                    list3 = new LinkedList<String>();
                }
                for (int i = 0; i < jSONArray.length(); ++i) {
                    list3.add(jSONArray.getString(i));
                }
            }
            JSONArray jSONArray2 = jSONObject.optJSONArray("impression_urls");
            List<String> list5 = list2 = adResponseParcel == null ? null : adResponseParcel.zzyx;
            if (jSONArray2 != null) {
                if (list2 == null) {
                    list2 = new LinkedList<String>();
                }
                for (int i = 0; i < jSONArray2.length(); ++i) {
                    list2.add(jSONArray2.getString(i));
                }
            }
            JSONArray jSONArray3 = jSONObject.optJSONArray("manual_impression_urls");
            List<String> list6 = list = adResponseParcel == null ? null : adResponseParcel.zzDZ;
            if (jSONArray3 != null) {
                if (list == null) {
                    list = new LinkedList<String>();
                }
                for (int i = 0; i < jSONArray3.length(); ++i) {
                    list.add(jSONArray3.getString(i));
                }
            }
            if (adResponseParcel != null) {
                if (adResponseParcel.orientation != -1) {
                    n = adResponseParcel.orientation;
                }
                if (adResponseParcel.zzDW > 0L) {
                    l2 = adResponseParcel.zzDW;
                }
            }
            String string9 = jSONObject.optString("active_view");
            String string10 = null;
            boolean bl2 = jSONObject.optBoolean("ad_is_javascript", false);
            if (bl2) {
                string10 = jSONObject.optString("ad_passback_url", null);
            }
            boolean bl3 = jSONObject.optBoolean("mediation", false);
            boolean bl4 = jSONObject.optBoolean("custom_render_allowed", false);
            boolean bl5 = jSONObject.optBoolean("content_url_opted_out", true);
            boolean bl6 = jSONObject.optBoolean("prefetch", false);
            int n2 = jSONObject.optInt("oauth2_token_status", 0);
            long l3 = jSONObject.optLong("refresh_interval_milliseconds", -1L);
            long l4 = jSONObject.optLong("mediation_config_cache_time_milliseconds", -1L);
            return new AdResponseParcel(adRequestInfoParcel, string3, string6, list3, list2, l2, bl3, l4, list, l3, n, string5, l, string7, bl2, string10, string9, bl4, bl, adRequestInfoParcel.zzDG, bl5, bl6, n2);
        }
        catch (JSONException jSONException) {
            zzb.zzaE("Could not parse the mediation config: " + jSONException.getMessage());
            return new AdResponseParcel(0);
        }
    }
}

