/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataReadResult
implements Result,
SafeParcelable {
    private final int mVersionCode;
    private final List<DataSet> zzany;
    private final Status zzQA;
    private final List<Bucket> zzaqG;
    private int zzaqH;
    private final List<DataSource> zzanI;
    private final List<DataType> zzaqI;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new zzc();

    DataReadResult(int versionCode, List<RawDataSet> dataSets, Status status, List<RawBucket> buckets, int batchCount, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.mVersionCode = versionCode;
        this.zzQA = status;
        this.zzaqH = batchCount;
        this.zzanI = uniqueDataSources;
        this.zzaqI = uniqueDataTypes;
        this.zzany = new ArrayList<DataSet>(dataSets.size());
        for (RawDataSet object : dataSets) {
            this.zzany.add(new DataSet(object, uniqueDataSources));
        }
        this.zzaqG = new ArrayList<Bucket>(buckets.size());
        for (RawBucket rawBucket : buckets) {
            this.zzaqG.add(new Bucket(rawBucket, uniqueDataSources));
        }
    }

    public DataReadResult(List<DataSet> dataSets, List<Bucket> buckets, Status status) {
        this.mVersionCode = 5;
        this.zzany = dataSets;
        this.zzQA = status;
        this.zzaqG = buckets;
        this.zzaqH = 1;
        this.zzanI = new ArrayList<DataSource>();
        this.zzaqI = new ArrayList<DataType>();
    }

    public static DataReadResult zza(Status status, DataReadRequest dataReadRequest) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource object : dataReadRequest.getDataSources()) {
            arrayList.add(DataSet.create(object));
        }
        for (DataType dataType : dataReadRequest.getDataTypes()) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzany) {
            if (!dataType.equals(dataSet.getDataType())) continue;
            return dataSet;
        }
        throw new IllegalArgumentException(String.format("Attempting to read data for %s, which was not requested", dataType.getName()));
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.zzany) {
            if (!dataSource.equals(dataSet.getDataSource())) continue;
            return dataSet;
        }
        throw new IllegalArgumentException(String.format("Attempting to read data for %s, which was not requested", dataSource.getStreamIdentifier()));
    }

    public List<DataSet> getDataSets() {
        return this.zzany;
    }

    public List<Bucket> getBuckets() {
        return this.zzaqG;
    }

    public int zzsB() {
        return this.zzaqH;
    }

    public void zzb(DataReadResult dataReadResult) {
        for (DataSet object : dataReadResult.getDataSets()) {
            this.zza(object, this.zzany);
        }
        for (Bucket bucket : dataReadResult.getBuckets()) {
            this.zza(bucket, this.zzaqG);
        }
    }

    private void zza(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals(dataSet.getDataSource())) continue;
            dataSet2.zzb(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    private void zza(Bucket bucket, List<Bucket> list) {
        for (Bucket bucket2 : list) {
            if (!bucket2.zzb(bucket)) continue;
            for (DataSet dataSet : bucket.getDataSets()) {
                this.zza(dataSet, bucket2.getDataSets());
            }
            return;
        }
        this.zzaqG.add(bucket);
    }

    public Status getStatus() {
        return this.zzQA;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadResult && this.zzc((DataReadResult)that);
    }

    private boolean zzc(DataReadResult dataReadResult) {
        return this.zzQA.equals((Object)dataReadResult.zzQA) && zzw.equal(this.zzany, dataReadResult.zzany) && zzw.equal(this.zzaqG, dataReadResult.zzaqG);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzQA, this.zzany, this.zzaqG});
    }

    public String toString() {
        return zzw.zzu((Object)this).zzg("status", (Object)this.zzQA).zzg("dataSets", this.zzany.size() > 5 ? this.zzany.size() + " data sets" : this.zzany).zzg("buckets", this.zzaqG.size() > 5 ? this.zzaqG.size() + " buckets" : this.zzaqG).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    List<RawBucket> zzsC() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.zzaqG.size());
        for (Bucket bucket : this.zzaqG) {
            arrayList.add(new RawBucket(bucket, this.zzanI, this.zzaqI));
        }
        return arrayList;
    }

    List<RawDataSet> zzsD() {
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(this.zzany.size());
        for (DataSet dataSet : this.zzany) {
            arrayList.add(new RawDataSet(dataSet, this.zzanI, this.zzaqI));
        }
        return arrayList;
    }

    List<DataSource> zzrE() {
        return this.zzanI;
    }

    List<DataType> zzsE() {
        return this.zzaqI;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzc.zza(this, dest, flags);
    }
}

