/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzv;
import com.google.android.gms.internal.zznf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final String zzaqv;
    private final String zzGY;
    private final long zzMS;
    private final long zzann;
    private final List<DataType> zzanw;
    private final List<DataSource> zzapG;
    private boolean zzaqw;
    private final boolean zzapR;
    private final List<String> zzaqx;
    private final zznf zzaqy;
    private final String zzOZ;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new zzv();

    SessionReadRequest(int versionCode, String sessionName, String sessionId, long startTimeMillis, long endTimeMillis, List<DataType> dataTypes, List<DataSource> dataSources, boolean getSessionsFromAllApps, boolean serverQueriesEnabled, List<String> excludedPackages, IBinder callback, String packageName) {
        this.mVersionCode = versionCode;
        this.zzaqv = sessionName;
        this.zzGY = sessionId;
        this.zzMS = startTimeMillis;
        this.zzann = endTimeMillis;
        this.zzanw = Collections.unmodifiableList(dataTypes);
        this.zzapG = Collections.unmodifiableList(dataSources);
        this.zzaqw = getSessionsFromAllApps;
        this.zzapR = serverQueriesEnabled;
        this.zzaqx = excludedPackages;
        this.zzaqy = callback == null ? null : zznf.zza.zzbH(callback);
        this.zzOZ = packageName;
    }

    private SessionReadRequest(Builder builder) {
        this(builder.zzaqv, builder.zzGY, builder.zzMS, builder.zzann, builder.zzanw, builder.zzapG, builder.zzaqw, builder.zzapR, builder.zzaqx, null, null);
    }

    public SessionReadRequest(SessionReadRequest request, zznf callback, String packageName) {
        this(request.zzaqv, request.zzGY, request.zzMS, request.zzann, request.zzanw, request.zzapG, request.zzaqw, request.zzapR, request.zzaqx, callback, packageName);
    }

    public SessionReadRequest(String sessionName, String sessionId, long startTimeMillis, long endTimeMillis, List<DataType> dataTypes, List<DataSource> dataSources, boolean getSessionsFromAllApps, boolean serverQueriesEnabled, List<String> excludedPackages, zznf callback, String packageName) {
        this.mVersionCode = 4;
        this.zzaqv = sessionName;
        this.zzGY = sessionId;
        this.zzMS = startTimeMillis;
        this.zzann = endTimeMillis;
        this.zzanw = Collections.unmodifiableList(dataTypes);
        this.zzapG = Collections.unmodifiableList(dataSources);
        this.zzaqw = getSessionsFromAllApps;
        this.zzapR = serverQueriesEnabled;
        this.zzaqx = excludedPackages;
        this.zzaqy = callback;
        this.zzOZ = packageName;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzMS, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzann, TimeUnit.MILLISECONDS);
    }

    public String getSessionName() {
        return this.zzaqv;
    }

    public String getSessionId() {
        return this.zzGY;
    }

    public List<DataType> getDataTypes() {
        return this.zzanw;
    }

    public List<DataSource> getDataSources() {
        return this.zzapG;
    }

    public boolean includeSessionsFromAllApps() {
        return this.zzaqw;
    }

    public List<String> getExcludedPackages() {
        return this.zzaqx;
    }

    public boolean zzsh() {
        return this.zzapR;
    }

    public long zzrw() {
        return this.zzann;
    }

    public long zzkH() {
        return this.zzMS;
    }

    public boolean zzsw() {
        return this.zzaqw;
    }

    public IBinder zzsc() {
        return this.zzaqy == null ? null : this.zzaqy.asBinder();
    }

    public String getPackageName() {
        return this.zzOZ;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof SessionReadRequest && this.zzb((SessionReadRequest)o);
    }

    private boolean zzb(SessionReadRequest sessionReadRequest) {
        return zzw.equal((Object)this.zzaqv, (Object)sessionReadRequest.zzaqv) && this.zzGY.equals(sessionReadRequest.zzGY) && this.zzMS == sessionReadRequest.zzMS && this.zzann == sessionReadRequest.zzann && zzw.equal(this.zzanw, sessionReadRequest.zzanw) && zzw.equal(this.zzapG, sessionReadRequest.zzapG) && this.zzaqw == sessionReadRequest.zzaqw && this.zzaqx.equals(sessionReadRequest.zzaqx) && this.zzapR == sessionReadRequest.zzapR;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzaqv, this.zzGY, this.zzMS, this.zzann});
    }

    public String toString() {
        return zzw.zzu((Object)this).zzg("sessionName", (Object)this.zzaqv).zzg("sessionId", (Object)this.zzGY).zzg("startTimeMillis", (Object)this.zzMS).zzg("endTimeMillis", (Object)this.zzann).zzg("dataTypes", this.zzanw).zzg("dataSources", this.zzapG).zzg("sessionsFromAllApps", (Object)this.zzaqw).zzg("excludedPackages", this.zzaqx).zzg("useServer", (Object)this.zzapR).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzv.zza(this, dest, flags);
    }

    public static class Builder {
        private String zzaqv;
        private String zzGY;
        private long zzMS = 0L;
        private long zzann = 0L;
        private List<DataType> zzanw = new ArrayList<DataType>();
        private List<DataSource> zzapG = new ArrayList<DataSource>();
        private boolean zzaqw = false;
        private boolean zzapR = false;
        private List<String> zzaqx = new ArrayList<String>();

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            this.zzMS = timeUnit.toMillis(startTime);
            this.zzann = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder setSessionName(String sessionName) {
            this.zzaqv = sessionName;
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.zzGY = sessionId;
            return this;
        }

        public Builder read(DataSource dataSource) {
            zzx.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            if (!this.zzapG.contains(dataSource)) {
                this.zzapG.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzx.zzb((Object)dataType, (Object)"Attempting to use a null data type");
            if (!this.zzanw.contains(dataType)) {
                this.zzanw.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.zzaqw = true;
            return this;
        }

        public Builder excludePackage(String appPackageName) {
            zzx.zzb((Object)appPackageName, (Object)"Attempting to use a null package name");
            if (!this.zzaqx.contains(appPackageName)) {
                this.zzaqx.add(appPackageName);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.zzapR = true;
            return this;
        }

        public SessionReadRequest build() {
            zzx.zzb((this.zzMS > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzMS});
            zzx.zzb((this.zzann > 0L && this.zzann > this.zzMS ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzann});
            return new SessionReadRequest(this);
        }
    }
}

