/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.zzh;
import com.google.android.gms.internal.zzmi;
import com.google.android.gms.internal.zznl;

public final class Device
implements SafeParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    private final int mVersionCode;
    private final String zzanY;
    private final String zzanZ;
    private final String zzWs;
    private final String zzaoa;
    private final int zzUS;
    private final int zzaob;
    public static final Parcelable.Creator<Device> CREATOR = new zzh();

    public static Device getLocalDevice(Context context) {
        int n = zzmi.zzaw(context);
        String string = Device.zzas(context);
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, string, n, 2);
    }

    private static String zzas(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public Device(String manufacturer, String model, String uid, int type) {
        this(manufacturer, model, "", uid, type, 0);
    }

    public Device(String manufacturer, String model, String version, String uid, int type, int platformType) {
        this(1, manufacturer, model, "", uid, type, platformType);
    }

    Device(int versionCode, String manufacturer, String model, String version, String uid, int type, int platformType) {
        this.mVersionCode = versionCode;
        this.zzanY = (String)zzx.zzv((Object)manufacturer);
        this.zzanZ = (String)zzx.zzv((Object)model);
        this.zzWs = "";
        this.zzaoa = (String)zzx.zzv((Object)uid);
        this.zzUS = type;
        this.zzaob = platformType;
    }

    public String getManufacturer() {
        return this.zzanY;
    }

    public String getModel() {
        return this.zzanZ;
    }

    public String getVersion() {
        return this.zzWs;
    }

    public String getUid() {
        return this.zzaoa;
    }

    public int getType() {
        return this.zzUS;
    }

    public int zzrI() {
        return this.zzaob;
    }

    private boolean zzrJ() {
        return this.zzrI() == 1;
    }

    String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.zzanY, this.zzanZ, this.zzaoa);
    }

    public String zzrK() {
        return this.zzrJ() ? this.zzaoa : zznl.zzcV(this.zzaoa);
    }

    public String toString() {
        return String.format("Device{%s:%s:%s:%s}", this.getStreamIdentifier(), this.zzWs, this.zzUS, this.zzaob);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Device && this.zza((Device)that);
    }

    private boolean zza(Device device) {
        return zzw.equal((Object)this.zzanY, (Object)device.zzanY) && zzw.equal((Object)this.zzanZ, (Object)device.zzanZ) && zzw.equal((Object)this.zzWs, (Object)device.zzWs) && zzw.equal((Object)this.zzaoa, (Object)device.zzaoa) && this.zzUS == device.zzUS && this.zzaob == device.zzaob;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzanY, this.zzanZ, this.zzWs, this.zzaoa, this.zzUS});
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzh.zza(this, parcel, flags);
    }
}

