/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.request.zze;
import com.google.android.gms.ads.internal.request.zzg;
import com.google.android.gms.ads.internal.request.zzj;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.internal.zzbr;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzgl;
import com.google.android.gms.internal.zzgm;
import com.google.android.gms.internal.zzhq;

@zzgk
public abstract class zzd
extends zzhq
implements zzc.zza {
    private final AdRequestInfoParcel zzyd;
    private final zzc.zza zzDt;
    private final Object zzpc = new Object();
    private AdResponseParcel zzCG;

    public zzd(AdRequestInfoParcel adRequestInfoParcel, zzc.zza zza2) {
        this.zzyd = adRequestInfoParcel;
        this.zzDt = zza2;
    }

    public abstract void zzfx();

    public abstract zzj zzfy();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(AdResponseParcel adResponseParcel) {
        Object object = this.zzpc;
        synchronized (object) {
            this.zzCG = adResponseParcel;
            this.zzpc.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzdG() {
        try {
            zzj zzj2 = this.zzfy();
            if (zzj2 == null) {
                AdResponseParcel adResponseParcel = new AdResponseParcel(0);
                this.zzDt.zzb(adResponseParcel);
            } else if (this.zza(zzj2, this.zzyd)) {
                this.zzi(zzp.zzbB().elapsedRealtime());
            }
        }
        finally {
            this.zzfx();
        }
    }

    @Override
    public final void onStop() {
        this.zzfx();
    }

    boolean zza(zzj zzj2, AdRequestInfoParcel adRequestInfoParcel) {
        try {
            zzj2.zza(adRequestInfoParcel, new zzg(this));
            return true;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service.", remoteException);
            zzp.zzbA().zzc(remoteException, true);
        }
        catch (NullPointerException nullPointerException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service due to an Exception.", nullPointerException);
            zzp.zzbA().zzc(nullPointerException, true);
        }
        catch (SecurityException securityException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service due to an Exception.", securityException);
            zzp.zzbA().zzc(securityException, true);
        }
        catch (Throwable throwable) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Could not fetch ad response from ad request service due to an Exception.", throwable);
            zzp.zzbA().zzc(throwable, true);
        }
        this.zzDt.zzb(new AdResponseParcel(0));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzi(long l) {
        Object object = this.zzpc;
        synchronized (object) {
            do {
                if (this.zzCG == null) continue;
                this.zzDt.zzb(this.zzCG);
                return;
            } while (this.zze(l));
            if (this.zzCG != null) {
                this.zzDt.zzb(this.zzCG);
            } else {
                this.zzDt.zzb(new AdResponseParcel(0));
            }
            return;
        }
    }

    protected boolean zze(long l) {
        long l2 = 60000L - (zzp.zzbB().elapsedRealtime() - l);
        if (l2 <= 0L) {
            return false;
        }
        try {
            this.zzpc.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    @zzgk
    public static class zzb
    extends zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private Context mContext;
        private AdRequestInfoParcel zzyd;
        private final zzc.zza zzDt;
        private final Object zzpc = new Object();
        protected zze zzDu;
        private boolean zzDv;

        public zzb(Context context, AdRequestInfoParcel adRequestInfoParcel, zzc.zza zza2) {
            super(adRequestInfoParcel, zza2);
            Looper looper;
            this.mContext = context;
            this.zzyd = adRequestInfoParcel;
            this.zzDt = zza2;
            if (zzby.zzuv.get().booleanValue()) {
                this.zzDv = true;
                looper = zzp.zzbI().zzgB();
            } else {
                looper = context.getMainLooper();
            }
            this.zzDu = new zze(context, looper, this, this, adRequestInfoParcel.zzqb.zzIB);
            this.connect();
        }

        protected void connect() {
            this.zzDu.zzox();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public zzj zzfy() {
            Object object = this.zzpc;
            synchronized (object) {
                try {
                    return this.zzDu.zzfC();
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzfx() {
            Object object = this.zzpc;
            synchronized (object) {
                if (this.zzDu.isConnected() || this.zzDu.isConnecting()) {
                    this.zzDu.disconnect();
                }
                Binder.flushPendingCommands();
                if (this.zzDv) {
                    zzp.zzbI().zzgC();
                    this.zzDv = false;
                }
            }
        }

        zzhq zzfz() {
            return new zza(this.mContext, this.zzyd, this.zzDt);
        }

        public void onConnectionFailed(ConnectionResult result) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaC("Cannot connect to remote service, fallback to local instance.");
            zzhq zzhq2 = this.zzfz();
            zzhq2.zzgn();
            Bundle bundle = new Bundle();
            bundle.putString("action", "gms_connection_failed_fallback_to_local");
            zzp.zzbx().zzb(this.mContext, this.zzyd.zzqb.zzIz, "gmob-apps", bundle, true);
        }

        public void onConnected(Bundle connectionHint) {
            this.zzgn();
        }

        public void onConnectionSuspended(int cause) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaC("Disconnected from remote ad request service.");
        }
    }

    @zzgk
    public static final class zza
    extends zzd {
        private final Context mContext;

        public zza(Context context, AdRequestInfoParcel adRequestInfoParcel, zzc.zza zza2) {
            super(adRequestInfoParcel, zza2);
            this.mContext = context;
        }

        @Override
        public zzj zzfy() {
            zzbr zzbr2 = new zzbr(zzby.zztW.get());
            return zzgm.zza(this.mContext, zzbr2, zzgl.zzfG());
        }

        @Override
        public void zzfx() {
        }
    }
}

