/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.zzm;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzaj;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzbk;
import com.google.android.gms.internal.zzea;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzhj;
import com.google.android.gms.internal.zzhq;
import com.google.android.gms.internal.zzhu;
import org.json.JSONException;
import org.json.JSONObject;

@zzgk
public class zzb
extends zzhq
implements zzc.zza {
    private final zza.zza zzDp;
    private final AdRequestInfoParcel.zza zzDq;
    private final Object zzCE = new Object();
    private final Context mContext;
    private final zzan zzwh;
    zzhq zzDr;
    Object zzpc = new Object();
    AdResponseParcel zzCG;
    zzea zzye;

    public zzb(Context context, AdRequestInfoParcel.zza zza2, zzan zzan2, zza.zza zza3) {
        this.zzDp = zza3;
        this.mContext = context;
        this.zzDq = zza2;
        this.zzwh = zzan2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(AdResponseParcel adResponseParcel) {
        Object object = this.zzpc;
        synchronized (object) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaC("Received ad response.");
            this.zzCG = adResponseParcel;
            this.zzpc.notify();
        }
    }

    zzhq zzb(AdRequestInfoParcel adRequestInfoParcel) {
        return zzc.zza(this.mContext, adRequestInfoParcel, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzdG() {
        Object object = this.zzpc;
        synchronized (object) {
            Object object2;
            zzhq zzhq2;
            com.google.android.gms.ads.internal.util.client.zzb.zzaC("AdLoaderBackgroundTask started.");
            zzaj zzaj2 = this.zzwh.zzab();
            String string = zzaj2.zzb(this.mContext);
            zzm zzm2 = zzm.zzq(this.mContext);
            String string2 = zzm2.getClientId();
            long l = zzp.zzbB().elapsedRealtime();
            AdRequestInfoParcel adRequestInfoParcel = new AdRequestInfoParcel(this.zzDq, string, string2, l);
            AdSizeParcel adSizeParcel = null;
            int n = -2;
            long l2 = -1L;
            try {
                zzhq2 = this.zzb(adRequestInfoParcel);
                object2 = this.zzCE;
                synchronized (object2) {
                    this.zzDr = zzhq2;
                    if (this.zzDr == null) {
                        throw new zza("Could not start the ad request service.", 0);
                    }
                }
                this.zzi(l);
                l2 = zzp.zzbB().elapsedRealtime();
                this.zzfw();
                if (adRequestInfoParcel.zzqf.zzsI != null) {
                    adSizeParcel = this.zzc(adRequestInfoParcel);
                }
                this.zzw(this.zzCG.zzEh);
            }
            catch (zza zza2) {
                n = zza2.getErrorCode();
                if (n == 3 || n == -1) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzaD(zza2.getMessage());
                } else {
                    com.google.android.gms.ads.internal.util.client.zzb.zzaE(zza2.getMessage());
                }
                this.zzCG = this.zzCG == null ? new AdResponseParcel(n) : new AdResponseParcel(n, this.zzCG.zzyA);
                zzhu.zzHK.post(new Runnable(){

                    @Override
                    public void run() {
                        zzb.this.onStop();
                    }
                });
            }
            zzhq2 = null;
            if (!TextUtils.isEmpty((CharSequence)this.zzCG.zzEf)) {
                try {
                    zzhq2 = new JSONObject(this.zzCG.zzEf);
                }
                catch (Exception exception) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzb("Error parsing the JSON for Active View.", exception);
                }
            }
            object2 = new zzhj.zza(adRequestInfoParcel, this.zzCG, this.zzye, adSizeParcel, n, l2, this.zzCG.zzEb, (JSONObject)zzhq2);
            this.zzDp.zza((zzhj.zza)object2);
        }
    }

    protected void zzw(boolean bl) {
        zzp.zzbA().zzA(bl);
        zzbk zzbk2 = zzp.zzbA().zzF(this.mContext);
        if (zzbk2 != null && !zzbk2.isAlive()) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaC("start fetching content...");
            zzbk2.zzct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzCE;
        synchronized (object) {
            if (this.zzDr != null) {
                this.zzDr.cancel();
            }
        }
    }

    protected void zzfw() throws zza {
        if (this.zzCG.errorCode == -3) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzCG.body)) {
            throw new zza("No fill from ad server.", 3);
        }
        zzp.zzbA().zza(this.mContext, this.zzCG.zzDG);
        if (this.zzCG.zzDX) {
            try {
                this.zzye = new zzea(this.zzCG.body);
            }
            catch (JSONException jSONException) {
                throw new zza("Could not parse mediation config: " + this.zzCG.body, 0);
            }
        }
    }

    protected AdSizeParcel zzc(AdRequestInfoParcel adRequestInfoParcel) throws zza {
        int n;
        int n2;
        if (this.zzCG.zzEa == null) {
            throw new zza("The ad response must specify one of the supported ad sizes.", 0);
        }
        String[] stringArray = this.zzCG.zzEa.split("x");
        if (stringArray.length != 2) {
            throw new zza("Invalid ad size format from the ad response: " + this.zzCG.zzEa, 0);
        }
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new zza("Invalid ad size number from the ad response: " + this.zzCG.zzEa, 0);
        }
        for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzqf.zzsI) {
            int n3;
            float f = this.mContext.getResources().getDisplayMetrics().density;
            int n4 = adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / f) : adSizeParcel.width;
            int n5 = n3 = adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / f) : adSizeParcel.height;
            if (n2 != n4 || n != n3) continue;
            return new AdSizeParcel(adSizeParcel, adRequestInfoParcel.zzqf.zzsI);
        }
        throw new zza("The ad size from the ad response was not one of the requested sizes: " + this.zzCG.zzEa, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzi(long l) throws zza {
        do {
            if (this.zze(l)) continue;
            throw new zza("Timed out waiting for ad response.", 2);
        } while (this.zzCG == null);
        Object object = this.zzCE;
        synchronized (object) {
            this.zzDr = null;
        }
        if (this.zzCG.errorCode != -2 && this.zzCG.errorCode != -3) {
            throw new zza("There was a problem getting an ad response. ErrorCode: " + this.zzCG.errorCode, this.zzCG.errorCode);
        }
    }

    protected boolean zze(long l) throws zza {
        long l2 = 60000L - (zzp.zzbB().elapsedRealtime() - l);
        if (l2 <= 0L) {
            return false;
        }
        try {
            this.zzpc.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            throw new zza("Ad request cancelled.", -1);
        }
        return true;
    }

    @zzgk
    static final class zza
    extends Exception {
        private final int zzCI;

        public zza(String string, int n) {
            super(string);
            this.zzCI = n;
        }

        public int getErrorCode() {
            return this.zzCI;
        }
    }
}

