/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzq;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.internal.zzcc;
import com.google.android.gms.internal.zzcd;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzip;
import java.util.HashMap;

@zzgk
public class zzk
extends FrameLayout
implements zzh {
    private final zzip zzoL;
    private final FrameLayout zzBb;
    private final zzq zzBc;
    private zzi zzBd;
    private boolean zzBe;
    private boolean zzBf;
    private TextView zzBg;
    private long zzBh;
    private long zzBi;
    private String zzBj;
    private String zzxs;

    public static void zzd(zzip zzip2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzip2.zzc("onVideoEvent", hashMap);
    }

    public zzk(Context context, zzip zzip2, int n, zzcd zzcd2, zzcc zzcc2) {
        super(context);
        this.zzoL = zzip2;
        this.zzBb = new FrameLayout(context);
        this.addView((View)this.zzBb);
        zzb.zzr((Object)zzip2.zzgP());
        this.zzBd = zzip2.zzgP().zzoG.zza(context, zzip2, n, zzcd2, zzcc2);
        this.zzBb.addView((View)this.zzBd, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        this.zzBg = new TextView(context);
        this.zzBg.setBackgroundColor(-16777216);
        this.zzeS();
        this.zzBc = new zzq(this);
        this.zzBc.zzfa();
        this.zzBd.zza(this);
    }

    public void zze(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3 + 2, n4 + 2);
        layoutParams.setMargins(n - 1, n2 - 1, 0, 0);
        this.zzBb.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public void setMimeType(String mimeType) {
        this.zzBj = mimeType;
    }

    public void zzak(String string) {
        this.zzxs = string;
    }

    public void zzeP() {
        if (!TextUtils.isEmpty((CharSequence)this.zzxs)) {
            this.zzBd.setMimeType(this.zzBj);
            this.zzBd.setVideoPath(this.zzxs);
        } else {
            this.zza("no_src", new String[0]);
        }
    }

    public void pause() {
        this.zzBd.pause();
    }

    public void play() {
        this.zzBd.play();
    }

    public void seekTo(int millis) {
        this.zzBd.seekTo(millis);
    }

    public void zzeq() {
        this.zzBd.zzeq();
    }

    public void zzer() {
        this.zzBd.zzer();
    }

    public void zza(float f) {
        this.zzBd.zza(f);
    }

    public void zzd(MotionEvent motionEvent) {
        this.zzBd.dispatchTouchEvent(motionEvent);
    }

    public void zzeQ() {
        Context context = this.zzBd.getContext();
        TextView textView = new TextView(context);
        textView.setText((CharSequence)("AdMob - " + this.zzBd.zzek()));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzBb.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzBb.bringChildToFront((View)textView);
    }

    @Override
    public void zzeK() {
    }

    @Override
    public void zzeL() {
        if (this.zzBi == 0L) {
            float f = (float)this.zzBd.getDuration() / 1000.0f;
            int n = this.zzBd.getVideoWidth();
            int n2 = this.zzBd.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public void zzeM() {
        this.zzeV();
    }

    @Override
    public void onPaused() {
        this.zza("pause", new String[0]);
        this.zzeW();
    }

    @Override
    public void zzeN() {
        this.zza("ended", new String[0]);
        this.zzeW();
    }

    @Override
    public void zzh(String string, String string2) {
        this.zza("error", "what", string, "extra", string2);
    }

    @Override
    public void zzeO() {
        this.zzeS();
        this.zzBi = this.zzBh;
    }

    public void destroy() {
        this.zzBc.cancel();
        this.zzBd.stop();
        this.zzeW();
    }

    void zzeR() {
        long l = this.zzBd.getCurrentPosition();
        if (this.zzBh != l && l > 0L) {
            this.zzeT();
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzBh = l;
        }
    }

    private void zzeS() {
        if (!this.zzeU()) {
            this.zzBb.addView((View)this.zzBg, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.zzBb.bringChildToFront((View)this.zzBg);
        }
    }

    private void zzeT() {
        if (this.zzeU()) {
            this.zzBb.removeView((View)this.zzBg);
        }
    }

    private boolean zzeU() {
        return this.zzBg.getParent() != null;
    }

    private void zza(String string, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string);
        String string2 = null;
        for (String string3 : stringArray) {
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            hashMap.put(string2, string3);
            string2 = null;
        }
        this.zzoL.zzc("onVideoEvent", hashMap);
    }

    private void zzeV() {
        if (this.zzoL.zzgN() == null) {
            return;
        }
        if (this.zzBe) {
            return;
        }
        WindowManager.LayoutParams layoutParams = this.zzoL.zzgN().getWindow().getAttributes();
        boolean bl = this.zzBf = (layoutParams.flags & 0x80) != 0;
        if (!this.zzBf) {
            this.zzoL.zzgN().getWindow().addFlags(128);
            this.zzBe = true;
        }
    }

    private void zzeW() {
        if (this.zzoL.zzgN() == null) {
            return;
        }
        if (this.zzBe && !this.zzBf) {
            this.zzoL.zzgN().getWindow().clearFlags(128);
            this.zzBe = false;
        }
    }
}

