/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzb;
import com.google.android.gms.ads.internal.client.zzc;
import com.google.android.gms.ads.internal.client.zzg;
import com.google.android.gms.ads.internal.client.zzi;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.client.zzr;
import com.google.android.gms.ads.internal.client.zzx;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzci;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzfr;
import com.google.android.gms.internal.zzfv;
import java.util.concurrent.atomic.AtomicBoolean;

public class zzy {
    private final zzeg zztk = new zzeg();
    private final zzg zznK;
    private final AtomicBoolean zztl;
    private AdListener zzso;
    private zza zzsn;
    private zzr zztm;
    private AdSize[] zzsL;
    private String zzoZ;
    private String zztn;
    private ViewGroup zzto;
    private AppEventListener zzsK;
    private InAppPurchaseListener zztp;
    private PlayStorePurchaseListener zztq;
    private OnCustomRenderedAdLoadedListener zztr;
    private boolean zzoM;

    public zzy(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzg.zzcA());
    }

    public zzy(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzg.zzcA());
    }

    zzy(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzg zzg2, zzr zzr2) {
        this.zzto = viewGroup;
        this.zznK = zzg2;
        this.zztm = zzr2;
        this.zztl = new AtomicBoolean(false);
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzj zzj2 = new zzj(context, attributeSet);
                this.zzsL = zzj2.zzi(bl);
                this.zzoZ = zzj2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzk.zzcE().zza(viewGroup, new AdSizeParcel(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                zzk.zzcE().zza(viewGroup, new AdSizeParcel(context, this.zzsL[0]), "Ads by Google");
            }
        }
    }

    zzy(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzg zzg2) {
        this(viewGroup, attributeSet, bl, zzg2, null);
    }

    public void destroy() {
        try {
            if (this.zztm != null) {
                this.zztm.destroy();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to destroy AdView.", remoteException);
        }
    }

    public AdListener getAdListener() {
        return this.zzso;
    }

    public AdSize getAdSize() {
        try {
            AdSizeParcel adSizeParcel;
            if (this.zztm != null && (adSizeParcel = this.zztm.zzaN()) != null) {
                return adSizeParcel.zzcC();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the current AdSize.", remoteException);
        }
        return this.zzsL != null ? this.zzsL[0] : null;
    }

    public AdSize[] getAdSizes() {
        return this.zzsL;
    }

    public String getAdUnitId() {
        return this.zzoZ;
    }

    public AppEventListener getAppEventListener() {
        return this.zzsK;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zztp;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zztr;
    }

    public void zza(zzx zzx2) {
        try {
            if (this.zztm == null) {
                this.zzcS();
            }
            if (this.zztm.zza(this.zznK.zza(this.zzto.getContext(), zzx2))) {
                this.zztk.zze(zzx2.zzcN());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to load ad.", remoteException);
        }
    }

    public void pause() {
        try {
            if (this.zztm != null) {
                this.zztm.pause();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to call pause.", remoteException);
        }
    }

    public void recordManualImpression() {
        if (this.zztl.getAndSet(true)) {
            return;
        }
        try {
            if (this.zztm != null) {
                this.zztm.zzaP();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to record impression.", remoteException);
        }
    }

    public void resume() {
        try {
            if (this.zztm != null) {
                this.zztm.resume();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to call resume.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        try {
            this.zzso = adListener;
            if (this.zztm != null) {
                this.zztm.zza(adListener != null ? new zzc(adListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdListener.", remoteException);
        }
    }

    public void zza(zza zza2) {
        try {
            this.zzsn = zza2;
            if (this.zztm != null) {
                this.zztm.zza(zza2 != null ? new zzb(zza2) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdSizes(AdSize ... adSizes) {
        if (this.zzsL != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizes);
    }

    public void zza(AdSize ... adSizeArray) {
        this.zzsL = adSizeArray;
        try {
            if (this.zztm != null) {
                this.zztm.zza(new AdSizeParcel(this.zzto.getContext(), this.zzsL));
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the ad size.", remoteException);
        }
        this.zzto.requestLayout();
    }

    public void setAdUnitId(String adUnitId) {
        if (this.zzoZ != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzoZ = adUnitId;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzsK = appEventListener;
            if (this.zztm != null) {
                this.zztm.zza(appEventListener != null ? new zzi(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zztq != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zztp = inAppPurchaseListener;
            if (this.zztm != null) {
                this.zztm.zza(inAppPurchaseListener != null ? new zzfr(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zztr = onCustomRenderedAdLoadedListener;
        try {
            if (this.zztm != null) {
                this.zztm.zza(onCustomRenderedAdLoadedListener != null ? new zzci(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the onCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String publicKey) {
        if (this.zztp != null) {
            throw new IllegalStateException("InAppPurchaseListener has already been set.");
        }
        try {
            this.zztq = playStorePurchaseListener;
            this.zztn = publicKey;
            if (this.zztm != null) {
                this.zztm.zza(playStorePurchaseListener != null ? new zzfv(playStorePurchaseListener) : null, publicKey);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public void setManualImpressionsEnabled(boolean manualImpressionsEnabled) {
        this.zzoM = manualImpressionsEnabled;
        try {
            if (this.zztm != null) {
                this.zztm.setManualImpressionsEnabled(this.zzoM);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set manual impressions.", remoteException);
        }
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zztm != null) {
                return this.zztm.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public boolean isLoading() {
        try {
            if (this.zztm != null) {
                return this.zztm.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to check if ad is loading.", remoteException);
        }
        return false;
    }

    private void zzcR() {
        try {
            zzd zzd2 = this.zztm.zzaM();
            if (zzd2 == null) {
                return;
            }
            this.zzto.addView((View)zze.zzp((zzd)zzd2));
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get an ad frame.", remoteException);
        }
    }

    void zzcS() throws RemoteException {
        if ((this.zzsL == null || this.zzoZ == null) && this.zztm == null) {
            throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
        }
        this.zztm = this.zzcT();
        if (this.zzso != null) {
            this.zztm.zza(new zzc(this.zzso));
        }
        if (this.zzsn != null) {
            this.zztm.zza(new zzb(this.zzsn));
        }
        if (this.zzsK != null) {
            this.zztm.zza(new zzi(this.zzsK));
        }
        if (this.zztp != null) {
            this.zztm.zza(new zzfr(this.zztp));
        }
        if (this.zztq != null) {
            this.zztm.zza(new zzfv(this.zztq), this.zztn);
        }
        if (this.zztr != null) {
            this.zztm.zza(new zzci(this.zztr));
        }
        this.zztm.zza(zzk.zzcG());
        this.zztm.setManualImpressionsEnabled(this.zzoM);
        this.zzcR();
    }

    protected zzr zzcT() throws RemoteException {
        Context context = this.zzto.getContext();
        return zzk.zzcF().zza(context, new AdSizeParcel(context, this.zzsL), this.zzoZ, this.zztk);
    }
}

