/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.zzlv;

public final class zzkr
extends Drawable
implements Drawable.Callback {
    private int zzacc = 0;
    private long zzMS;
    private int mFrom;
    private int zzacd;
    private int zzace = 255;
    private int zzacf;
    private int zzacg = 0;
    private boolean zzabV = true;
    private boolean zzach;
    private zzb zzaci;
    private Drawable zzacj;
    private Drawable zzack;
    private boolean zzacl;
    private boolean zzacm;
    private boolean zzacn;
    private int zzaco;

    public zzkr(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zza.zzacp;
        }
        this.zzacj = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzaci.zzacs |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zza.zzacp;
        }
        this.zzack = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zzaci.zzacs |= drawable3.getChangingConfigurations();
    }

    zzkr(zzb zzb2) {
        this.zzaci = new zzb(zzb2);
    }

    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback;
        if (zzlv.zzpO() && (callback = this.getCallback()) != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback;
        if (zzlv.zzpO() && (callback = this.getCallback()) != null) {
            callback.scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback;
        if (zzlv.zzpO() && (callback = this.getCallback()) != null) {
            callback.unscheduleDrawable((Drawable)this, what);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzaci.zzacr | this.zzaci.zzacs;
    }

    public void setAlpha(int alpha) {
        if (this.zzacg == this.zzace) {
            this.zzacg = alpha;
        }
        this.zzace = alpha;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter cf) {
        this.zzacj.setColorFilter(cf);
        this.zzack.setColorFilter(cf);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.zzacj.getIntrinsicWidth(), this.zzack.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.zzacj.getIntrinsicHeight(), this.zzack.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect bounds) {
        this.zzacj.setBounds(bounds);
        this.zzack.setBounds(bounds);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzaci.zzacr = this.getChangingConfigurations();
            return this.zzaci;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.zzacn) {
            this.zzaco = Drawable.resolveOpacity((int)this.zzacj.getOpacity(), (int)this.zzack.getOpacity());
            this.zzacn = true;
        }
        return this.zzaco;
    }

    public boolean canConstantState() {
        if (!this.zzacl) {
            this.zzacm = this.zzacj.getConstantState() != null && this.zzack.getConstantState() != null;
            this.zzacl = true;
        }
        return this.zzacm;
    }

    public Drawable mutate() {
        if (!this.zzach && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzacj.mutate();
            this.zzack.mutate();
            this.zzach = true;
        }
        return this;
    }

    public Drawable zzod() {
        return this.zzack;
    }

    public void startTransition(int durationMillis) {
        this.mFrom = 0;
        this.zzacd = this.zzace;
        this.zzacg = 0;
        this.zzacf = durationMillis;
        this.zzacc = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzacc) {
            case 1: {
                this.zzMS = SystemClock.uptimeMillis();
                bl = false;
                this.zzacc = 2;
                break;
            }
            case 2: {
                if (this.zzMS < 0L) break;
                float f = (float)(SystemClock.uptimeMillis() - this.zzMS) / (float)this.zzacf;
                boolean bl2 = bl = f >= 1.0f;
                if (bl) {
                    this.zzacc = 0;
                }
                f = Math.min(f, 1.0f);
                this.zzacg = (int)((float)this.mFrom + (float)(this.zzacd - this.mFrom) * f);
            }
        }
        int n = this.zzacg;
        boolean bl3 = this.zzabV;
        Drawable drawable2 = this.zzacj;
        Drawable drawable3 = this.zzack;
        if (bl) {
            if (!bl3 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zzace) {
                drawable3.setAlpha(this.zzace);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl3) {
            drawable2.setAlpha(this.zzace - n);
        }
        drawable2.draw(canvas);
        if (bl3) {
            drawable2.setAlpha(this.zzace);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zzace);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.zzkr$zza
    extends Drawable {
        private static final com.google.android.gms.internal.zzkr$zza zzacp = new com.google.android.gms.internal.zzkr$zza();
        private static final zza zzacq = new zza();

        private com.google.android.gms.internal.zzkr$zza() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return zzacq;
        }

        private static final class zza
        extends Drawable.ConstantState {
            private zza() {
            }

            public Drawable newDrawable() {
                return zzacp;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class zzb
    extends Drawable.ConstantState {
        int zzacr;
        int zzacs;

        zzb(zzb zzb2) {
            if (zzb2 != null) {
                this.zzacr = zzb2.zzacr;
                this.zzacs = zzb2.zzacs;
            }
        }

        public Drawable newDrawable() {
            return new zzkr(this);
        }

        public int getChangingConfigurations() {
            return this.zzacr;
        }
    }
}

