/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.games.GameManagerClient;
import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.cast.internal.zzo;
import com.google.android.gms.cast.internal.zzp;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzkf;
import com.google.android.gms.internal.zzkg;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzki;
import com.google.android.gms.internal.zzkj;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class zzkd
extends com.google.android.gms.cast.internal.zzc {
    static final String NAMESPACE = zzf.zzbM("com.google.cast.games");
    private static final zzl zzTy = new zzl("GameManagerChannel");
    private final Map<String, String> zzVP = new ConcurrentHashMap<String, String>();
    private final List<zzp> zzVQ;
    private final SharedPreferences zztU;
    private final String zzVR;
    private final Cast.CastApi zzVS;
    private final GoogleApiClient zzVT;
    private zzke zzVU;
    private boolean zzVV = false;
    private GameManagerState zzVW;
    private GameManagerState zzVX;
    private String zzVY;
    private JSONObject zzVZ;
    private long zzWa = 0L;
    private GameManagerClient.Listener zzWb;
    private String zzWc;

    public zzkd(GoogleApiClient googleApiClient, String string2, Cast.CastApi castApi) throws IllegalArgumentException, IllegalStateException {
        super(NAMESPACE, "CastGameManagerChannel", null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("castSessionId cannot be null.");
        }
        if (googleApiClient == null || !googleApiClient.isConnected() || !googleApiClient.hasConnectedApi(Cast.API)) {
            throw new IllegalArgumentException("googleApiClient needs to be connected and contain the Cast.API API.");
        }
        this.zzVQ = new ArrayList<zzp>();
        this.zzVR = string2;
        this.zzVS = castApi;
        this.zzVT = googleApiClient;
        Context context = googleApiClient.getContext().getApplicationContext();
        String string3 = String.format(Locale.ROOT, "%s.%s", context.getPackageName(), "game_manager_channel_data");
        this.zztU = context.getApplicationContext().getSharedPreferences(string3, 0);
        this.zzVX = null;
        this.zzVW = new zzkh(0, 0, "", null, new ArrayList<PlayerInfo>(), "", -1);
    }

    public synchronized PendingResult<GameManagerClient.GameManagerInstanceResult> zza(GameManagerClient gameManagerClient) throws IllegalArgumentException {
        if (gameManagerClient == null) {
            throw new IllegalArgumentException("gameManagerClient can't be null.");
        }
        return this.zzVT.zzb((zzc.zza)new zzc(gameManagerClient){

            @Override
            public void execute() {
                try {
                    zzkd.this.zzVS.setMessageReceivedCallbacks(zzkd.this.zzVT, zzkd.this.getNamespace(), new Cast.MessageReceivedCallback(){

                        @Override
                        public void onMessageReceived(CastDevice castDevice, String namespace, String message) {
                            zzkd.this.zzbJ(message);
                        }
                    });
                }
                catch (IOException | IllegalStateException exception) {
                    this.zzmk().zza(-1L, 8, null);
                    return;
                }
                zzkd.this.zzmi();
                zzkd.this.zzmh();
                zzkd.this.zza(null, 1100, null, this.zzmk());
            }
        });
    }

    public synchronized void dispose() throws IllegalStateException {
        if (this.zzVV) {
            return;
        }
        this.zzVW = null;
        this.zzVX = null;
        this.zzVY = null;
        this.zzVZ = null;
        this.zzVV = true;
        try {
            this.zzVS.removeMessageReceivedCallbacks(this.zzVT, this.getNamespace());
        }
        catch (IOException iOException) {
            zzTy.zzf("Exception while detaching game manager channel.", iOException);
        }
    }

    public synchronized PendingResult<GameManagerClient.GameManagerResult> zza(final String string2, final int n, final JSONObject jSONObject) throws IllegalStateException {
        this.zzmf();
        return this.zzVT.zzb((zzc.zza)new zza(){

            @Override
            public void execute() {
                int n2 = zzkg.zzaR(n);
                if (n2 == 0) {
                    this.zzmk().zza(-1L, 2001, null);
                    zzTy.zzf("sendPlayerRequest for unsupported playerState: %d", n);
                    return;
                }
                zzkd.this.zza(string2, n2, jSONObject, this.zzmk());
            }
        });
    }

    public synchronized void sendGameMessage(String playerId, JSONObject extraMessageData) throws IllegalStateException {
        this.zzmf();
        long l = ++this.zzWa;
        JSONObject jSONObject = this.zza(l, playerId, 7, extraMessageData);
        if (jSONObject == null) {
            return;
        }
        this.zzVS.sendMessage(this.zzVT, this.getNamespace(), jSONObject.toString());
    }

    public synchronized PendingResult<GameManagerClient.GameManagerResult> sendGameRequest(final String playerId, final JSONObject extraMessageData) throws IllegalStateException {
        this.zzmf();
        return this.zzVT.zzb((zzc.zza)new zza(){

            @Override
            public void execute() {
                zzkd.this.zza(playerId, 6, extraMessageData, this.zzmk());
            }
        });
    }

    public synchronized GameManagerState getCurrentState() throws IllegalStateException {
        this.zzmf();
        return this.zzVW;
    }

    public synchronized String getLastUsedPlayerId() throws IllegalStateException {
        this.zzmf();
        return this.zzWc;
    }

    public synchronized String zzbI(String string2) throws IllegalStateException {
        return string2 == null ? null : this.zzVP.get(string2);
    }

    public synchronized void setListener(GameManagerClient.Listener listener) {
        this.zzWb = listener;
    }

    @Override
    public final void zzbJ(String string2) {
        boolean bl;
        zzkf zzkf2;
        zzTy.zzb("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            zzkf2 = zzkf.zzh(jSONObject);
        }
        catch (JSONException jSONException) {
            zzTy.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
        if (zzkf2 == null) {
            zzTy.zzf("Could not parse game manager message from string: %s", string2);
            return;
        }
        if (!this.isInitialized() && zzkf2.zzmr() == null || this.isDisposed()) {
            return;
        }
        boolean bl2 = bl = zzkf2.zzmm() == 1;
        if (bl && !TextUtils.isEmpty((CharSequence)zzkf2.zzmq())) {
            this.zzVP.put(zzkf2.getPlayerId(), zzkf2.zzmq());
            this.zzmh();
        }
        if (zzkf2.getStatusCode() == 0) {
            this.zza(zzkf2);
        } else {
            zzTy.zzf("Not updating from game message because the message contains error code: %d", zzkf2.getStatusCode());
        }
        int n = this.zzaQ(zzkf2.getStatusCode());
        if (bl) {
            this.zzb(zzkf2.getRequestId(), n, zzkf2);
        }
        if (this.isInitialized() && n == 0) {
            this.zzmg();
        }
    }

    public synchronized boolean isDisposed() {
        return this.zzVV;
    }

    public synchronized boolean isInitialized() {
        return this.zzVU != null;
    }

    @Override
    public void zzb(long l, int n) {
        this.zzb(l, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zzz(long l) {
        Iterator<zzp> iterator = this.zzVQ.iterator();
        while (iterator.hasNext()) {
            zzp zzp2 = iterator.next();
            if (!zzp2.zzd(l, 15)) continue;
            iterator.remove();
        }
        boolean bl = false;
        Object object = zzp.zzXT;
        synchronized (object) {
            for (zzp zzp3 : this.zzVQ) {
                if (!zzp3.zzmO()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private int zzaQ(int n) {
        switch (n) {
            case 4: {
                return 2151;
            }
            case 3: {
                return 2150;
            }
            case 2: {
                return 2003;
            }
            case 1: {
                return 2001;
            }
            case 0: {
                return 0;
            }
        }
        zzTy.zzf("Unknown GameManager protocol status code: " + n, new Object[0]);
        return 13;
    }

    private synchronized void zzmf() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel before it is initialized.");
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel after it has been disposed.");
        }
    }

    private void zza(String string2, int n, JSONObject jSONObject, zzo zzo2) {
        long l;
        JSONObject jSONObject2;
        if ((jSONObject2 = this.zza(l = ++this.zzWa, string2, n, jSONObject)) == null) {
            zzo2.zza(-1L, 2001, null);
            zzTy.zzf("Not sending request because it was invalid.", new Object[0]);
            return;
        }
        zzp zzp2 = new zzp(30000L);
        zzp2.zza(l, zzo2);
        this.zzVQ.add(zzp2);
        this.zzU(true);
        this.zzVS.sendMessage(this.zzVT, this.getNamespace(), jSONObject2.toString()).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void zzr(Status status) {
                if (!status.isSuccess()) {
                    zzkd.this.zzb(l, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(Result x0) {
                this.zzr((Status)x0);
            }
        });
    }

    private JSONObject zza(long l, String string2, int n, JSONObject jSONObject) {
        JSONObject jSONObject2;
        try {
            jSONObject2 = new JSONObject();
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", n);
            jSONObject2.put("extraMessageData", (Object)jSONObject);
            jSONObject2.put("playerId", (Object)string2);
            jSONObject2.put("playerToken", (Object)this.zzbI(string2));
        }
        catch (JSONException jSONException) {
            zzTy.zzf("JSONException when trying to create a message: %s", jSONException.getMessage());
            jSONObject2 = null;
        }
        return jSONObject2;
    }

    private synchronized void zza(zzkf zzkf2) {
        boolean bl = zzkf2.zzmm() == 1;
        this.zzVX = this.zzVW;
        if (bl && zzkf2.zzmr() != null) {
            this.zzVU = zzkf2.zzmr();
        }
        if (!this.isInitialized()) {
            return;
        }
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (zzkj zzkj2 : zzkf2.zzmo()) {
            String string2 = zzkj2.getPlayerId();
            zzki zzki2 = new zzki(string2, zzkj2.getPlayerState(), zzkj2.getPlayerData(), this.zzVP.containsKey(string2));
            arrayList.add(zzki2);
        }
        this.zzVW = new zzkh(zzkf2.getLobbyState(), zzkf2.getGameplayState(), zzkf2.zzmp(), zzkf2.getGameData(), arrayList, this.zzVU.zzml(), this.zzVU.getMaxPlayers());
        PlayerInfo playerInfo = this.zzVW.getPlayer(zzkf2.getPlayerId());
        if (playerInfo != null && playerInfo.isControllable() && zzkf2.zzmm() == 2) {
            this.zzVY = zzkf2.getPlayerId();
            this.zzVZ = zzkf2.getExtraMessageData();
        }
    }

    private void zzmg() {
        if (this.zzWb != null) {
            if (this.zzVX != null && !this.zzVW.equals(this.zzVX)) {
                this.zzWb.onStateChanged(this.zzVW, this.zzVX);
            }
            if (this.zzVZ != null && this.zzVY != null) {
                this.zzWb.onGameMessageReceived(this.zzVY, this.zzVZ);
            }
        }
        this.zzVX = null;
        this.zzVY = null;
        this.zzVZ = null;
    }

    private void zzb(long l, int n, Object object) {
        Iterator<zzp> iterator = this.zzVQ.iterator();
        while (iterator.hasNext()) {
            zzp zzp2 = iterator.next();
            if (!zzp2.zzc(l, n, object)) continue;
            iterator.remove();
        }
    }

    private synchronized void zzmh() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("castSessionId", (Object)this.zzVR);
            jSONObject.put("playerTokenMap", (Object)new JSONObject(this.zzVP));
            this.zztU.edit().putString("save_data", jSONObject.toString()).commit();
        }
        catch (JSONException jSONException) {
            zzTy.zzf("Error while saving data: %s", jSONException.getMessage());
        }
    }

    private synchronized void zzmi() {
        String string2 = this.zztU.getString("save_data", null);
        if (string2 == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("castSessionId");
            if (this.zzVR.equals(string3)) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("playerTokenMap");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    this.zzVP.put(string4, jSONObject2.getString(string4));
                }
                this.zzWa = 0L;
            }
        }
        catch (JSONException jSONException) {
            zzTy.zzf("Error while loading data: %s", jSONException.getMessage());
        }
    }

    public abstract class zza
    extends zzb<GameManagerClient.GameManagerResult> {
        public zza() {
            this.zzVC = new zzo(){

                @Override
                public void zzy(long l) {
                    zza.this.zza(zza.this.zzt(new Status(2103)));
                }

                @Override
                public void zza(long l, int n, Object object) {
                    try {
                        if (object == null) {
                            zza.this.zza(new zze(new Status(n, null, null), null, l, null));
                            return;
                        }
                        zzkf zzkf2 = (zzkf)object;
                        String string2 = zzkf2.getPlayerId();
                        if (n == 0 && string2 != null) {
                            zzkd.this.zzWc = string2;
                        }
                        zza.this.zza(new zze(new Status(n, zzkf2.zzmn(), null), string2, zzkf2.getRequestId(), zzkf2.getExtraMessageData()));
                    }
                    catch (ClassCastException classCastException) {
                        zza.this.zza(zza.this.zzt(new Status(13)));
                    }
                }
            };
        }

        public GameManagerClient.GameManagerResult zzt(Status status) {
            return new zze(status, null, -1L, null);
        }

        public /* synthetic */ Result zzb(Status status) {
            return this.zzt(status);
        }
    }

    public abstract class zzc
    extends zzb<GameManagerClient.GameManagerInstanceResult> {
        private GameManagerClient zzWl;

        public zzc(GameManagerClient gameManagerClient) {
            this.zzWl = gameManagerClient;
            this.zzVC = new zzo(){

                @Override
                public void zzy(long l) {
                    zzc.this.zza(zzc.this.zzu(new Status(2103)));
                }

                @Override
                public void zza(long l, int n, Object object) {
                    try {
                        if (object == null) {
                            zzc.this.zza(new zzd(new Status(n, null, null), zzc.this.zzWl));
                            return;
                        }
                        zzkf zzkf2 = (zzkf)object;
                        zzke zzke2 = zzkf2.zzmr();
                        if (zzke2 != null && !zzf.zza("1.0.0", zzke2.getVersion())) {
                            zzc.this.zza(zzc.this.zzu(new Status(2150, String.format(Locale.ROOT, "Incorrect Game Manager SDK version. Receiver: %s Sender: %s", zzke2.getVersion(), "1.0.0"))));
                            zzkd.this.zzVU = null;
                            return;
                        }
                        zzc.this.zza(new zzd(new Status(n, zzkf2.zzmn(), null), zzc.this.zzWl));
                    }
                    catch (ClassCastException classCastException) {
                        zzc.this.zza(zzc.this.zzu(new Status(13)));
                    }
                }
            };
        }

        public GameManagerClient.GameManagerInstanceResult zzu(Status status) {
            return new zzd(status, null);
        }

        public /* synthetic */ Result zzb(Status status) {
            return this.zzu(status);
        }
    }

    public abstract class zzb<R extends Result>
    extends com.google.android.gms.cast.internal.zzb<R> {
        protected zzo zzVC;

        public zzb() {
            super(zzkd.this.zzVT);
        }

        protected void zza(com.google.android.gms.cast.internal.zze zze2) {
            this.execute();
        }

        public zzo zzmk() {
            return this.zzVC;
        }

        public abstract void execute();
    }

    private static final class zze
    implements GameManagerClient.GameManagerResult {
        private final Status zzQA;
        private final String zzWn;
        private final long zzWo;
        private final JSONObject zzWp;

        zze(Status status, String string2, long l, JSONObject jSONObject) {
            this.zzQA = status;
            this.zzWn = string2;
            this.zzWo = l;
            this.zzWp = jSONObject;
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public String getPlayerId() {
            return this.zzWn;
        }

        @Override
        public long getRequestId() {
            return this.zzWo;
        }

        @Override
        public JSONObject getExtraMessageData() {
            return this.zzWp;
        }
    }

    private static final class zzd
    implements GameManagerClient.GameManagerInstanceResult {
        private final Status zzQA;
        private final GameManagerClient zzWl;

        zzd(Status status, GameManagerClient gameManagerClient) {
            this.zzQA = status;
            this.zzWl = gameManagerClient;
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public GameManagerClient getGameManagerClient() {
            return this.zzWl;
        }
    }
}

